/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.grid;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPowerIdleChange;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import com.mordenkainen.equivalentenergistics.blocks.base.tile.EqETileBase;
import com.mordenkainen.equivalentenergistics.core.TickHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridAccessException;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.IAEProxyHost;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class AEProxy
implements IGridBlock {
    private final IAEProxyHost proxy;
    private IGridNode node;
    private double idleDraw;
    private EnumSet<GridFlags> flags = EnumSet.noneOf(GridFlags.class);
    private final boolean worldNode;
    private AEColor gridColor = AEColor.Transparent;
    private EnumSet<ForgeDirection> validSides;
    private ItemStack displayStack;
    private final String nbtName;
    private NBTTagCompound data;
    private boolean ready;
    private EntityPlayer owner;

    public AEProxy(IAEProxyHost proxy, String name, ItemStack displayStack, boolean inWorld) {
        this.proxy = proxy;
        this.nbtName = name;
        this.worldNode = inWorld;
        this.displayStack = displayStack;
        this.validSides = EnumSet.allOf(ForgeDirection.class);
    }

    public double getIdlePowerUsage() {
        return this.idleDraw;
    }

    public void setIdlePowerUsage(double idle) {
        this.idleDraw = idle;
        if (this.node != null) {
            try {
                this.getGrid().postEvent((MENetworkEvent)new MENetworkPowerIdleChange(this.node));
            }
            catch (GridAccessException e) {
                CommonUtils.debugLog("AEProxy:setIdlePowerUsage: Error accessing grid:", e);
            }
        }
    }

    public EnumSet<GridFlags> getFlags() {
        return this.flags;
    }

    public void setFlags(GridFlags ... gridFlags) {
        EnumSet<GridFlags> newFlags = EnumSet.noneOf(GridFlags.class);
        Collections.addAll(newFlags, gridFlags);
        this.flags = newFlags;
    }

    public boolean isWorldAccessible() {
        return this.worldNode;
    }

    public DimensionalCoord getLocation() {
        return this.proxy.getLocation();
    }

    public AEColor getGridColor() {
        return this.gridColor;
    }

    public void setColor(AEColor newColor) {
        this.gridColor = newColor;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return this.validSides;
    }

    public void setConnectableSides(EnumSet<ForgeDirection> validSides) {
        this.validSides = validSides;
        if (this.node != null) {
            this.node.updateState();
        }
    }

    public IGridHost getMachine() {
        return this.proxy;
    }

    public void gridChanged() {
        this.proxy.gridChanged();
    }

    public ItemStack getMachineRepresentation() {
        return this.displayStack;
    }

    public void setMachineRepresentation(ItemStack stack) {
        this.displayStack = stack;
    }

    public IGrid getGrid() throws GridAccessException {
        IGrid grid;
        if (this.node != null && (grid = this.node.getGrid()) != null) {
            return grid;
        }
        throw new GridAccessException();
    }

    public IGridNode getNode() {
        if (this.node == null && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.ready) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this);
            this.readFromNBT(this.data);
            this.node.updateState();
        }
        return this.node;
    }

    public void invalidate() {
        this.ready = false;
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
        }
    }

    public void onReady() {
        this.ready = true;
        this.getNode();
    }

    public boolean isActive() {
        return this.node != null && this.node.isActive();
    }

    public boolean isPowered() {
        try {
            return GridUtils.getEnergy(this).isNetworkPowered();
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("AEProxy:isPowered: Error accessing grid:", e);
            return false;
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void onChunkUnload() {
        this.invalidate();
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data = tag;
        if (this.node != null && this.data != null) {
            this.node.loadFromNBT(this.nbtName, this.data);
            this.data = null;
        } else if (this.node != null && this.owner != null) {
            this.node.setPlayerID(AEApi.instance().registries().players().getID(this.owner));
            this.owner = null;
        }
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    public void validate() {
        if (this.proxy instanceof EqETileBase) {
            TickHandler.INSTANCE.addInit((EqETileBase)((Object)this.proxy));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.node != null) {
            this.node.saveToNBT(this.nbtName, tag);
        }
    }

    public boolean meetsChannelRequirements() {
        if (this.node == null) {
            return false;
        }
        return this.node.meetsChannelRequirements();
    }
}

