/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration;

import com.google.common.base.Predicate;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.ConfigManager;
import com.mordenkainen.equivalentenergistics.integration.IEMCHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.AppliedEnergistics2;
import com.mordenkainen.equivalentenergistics.integration.ee3.EquivExchange3;
import com.mordenkainen.equivalentenergistics.integration.projecte.ProjectE;
import com.mordenkainen.equivalentenergistics.integration.waila.Waila;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.relauncher.Side;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

public final class Integration {
    public static IEMCHandler emcHandler;

    private Integration() {
    }

    public static void loadConfig(Configuration config) {
        for (Mods mod : Mods.values()) {
            mod.loadConfig(config);
        }
    }

    public static void preInit() {
    }

    public static void init() {
        if (Mods.WAILA.isEnabled()) {
            Waila.init();
        }
        if (Mods.AE2.isEnabled()) {
            AppliedEnergistics2.init();
        }
        emcHandler = ConfigManager.useEE3 ? new EquivExchange3() : new ProjectE();
    }

    public static void postInit() {
        emcHandler.setCrystalEMC();
        MinecraftForge.EVENT_BUS.register((Object)emcHandler);
    }

    public static enum Mods {
        WAILA("Waila"),
        NEI("NotEnoughItems", Side.CLIENT),
        EE3("EE3", "EquivalentExchange3"),
        PROJECTE("ProjectE"),
        AE2("appliedenergistics2", false);

        private final String modID;
        private boolean shouldLoad = true;
        private final String name;
        private final Side modSide;
        private final boolean usesConfig;

        private Mods(String modid) {
            this(modid, modid, null, true);
        }

        private Mods(String modid, boolean hasConfig) {
            this(modid, modid, null, hasConfig);
        }

        private Mods(String modid, String modName) {
            this(modid, modName, null, true);
        }

        private Mods(String modid, Side side) {
            this(modid, modid, side, true);
        }

        private Mods(String modid, String modName, boolean hasConfig) {
            this(modid, modName, null, hasConfig);
        }

        private Mods(String modid, String modName, Side side) {
            this(modid, modid, side, true);
        }

        private Mods(String modid, Side side, boolean hasConfig) {
            this(modid, modid, side, hasConfig);
        }

        private Mods(String modid, String modName, Side side, boolean hasConfig) {
            this.modID = modid;
            this.name = modName;
            this.modSide = side;
            this.usesConfig = hasConfig;
        }

        public String getModID() {
            return this.modID;
        }

        public String getModName() {
            return this.name;
        }

        public boolean isOnClient() {
            return this.modSide != Side.SERVER;
        }

        public boolean isOnServer() {
            return this.modSide != Side.CLIENT;
        }

        public void loadConfig(Configuration config) {
            this.shouldLoad = this.usesConfig ? config.get("Integration", "enable" + this.getModName(), true, "Enable " + this.getModName() + " Integration.").getBoolean(true) : true;
        }

        public boolean isEnabled() {
            return (Loader.isModLoaded((String)this.getModID()) || ModAPIManager.INSTANCE.hasAPI(this.getModID())) && this.shouldLoad && this.correctSide();
        }

        public Predicate<Mods> getTest() {
            return new Predicate<Mods>(){

                public boolean apply(Mods input) {
                    return this.isEnabled();
                }
            };
        }

        private boolean correctSide() {
            return EquivalentEnergistics.proxy.isClient() ? this.isOnClient() : this.isOnServer();
        }
    }
}

