/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.render;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import com.mordenkainen.equivalentenergistics.blocks.crafter.model.ModelEMCCrafter;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterBase;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEMCCrafterRenderer
extends TileEntitySpecialRenderer {
    private static final ModelEMCCrafter MODEL = new ModelEMCCrafter();
    private static final ResourceLocation[] MODELTEXTURES = new ResourceLocation[]{new ResourceLocation("equivalentenergistics:textures/models/EMCCrafter.png"), new ResourceLocation("equivalentenergistics:textures/models/EMCCrafterAdv.png"), new ResourceLocation("equivalentenergistics:textures/models/EMCCrafterExt.png"), new ResourceLocation("equivalentenergistics:textures/models/EMCCrafterUlt.png")};

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        if (!(tile instanceof TileEMCCrafterBase)) {
            return;
        }
        TileEMCCrafterBase crafter = (TileEMCCrafterBase)tile;
        this.renderCrafter(x, y, z, crafter.func_145832_p());
        if (crafter.func_145831_w() != null) {
            if (crafter.isActive()) {
                this.renderLights(crafter, x, y, z);
            }
            this.renderConnectors(crafter, x, y, z);
            this.renderContent(crafter, x, y, z, partialTicks);
        }
    }

    private void renderCrafter(double x, double y, double z, int metaData) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.func_147499_a(MODELTEXTURES[metaData]);
        MODEL.render();
        GL11.glPopMatrix();
    }

    private void renderLights(TileEMCCrafterBase tile, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_147499_a(TextureMap.field_110575_b);
        IIcon tex = tile.isErrored() ? TextureEnum.EMCASSEMBLER.getTexture(1) : TextureEnum.EMCASSEMBLER.getTexture(0);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78369_a(1.0f, 1.0f, 1.0f, 0.3f);
        Tessellator.field_78398_a.func_78380_c(0xE000E0);
        Tessellator.field_78398_a.func_78374_a(1.0625, -0.0625, 0.9375, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0625, 1.0625, 0.9375, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 1.0625, 0.9375, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(-0.0625, -0.0625, 0.9375, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(-0.0625, -0.0625, 0.0625, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 1.0625, 0.0625, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(1.0625, 1.0625, 0.0625, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(1.0625, -0.0625, 0.0625, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.9375, -0.0625, -0.0625, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.9375, 1.0625, -0.0625, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.9375, 1.0625, 1.0625, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.9375, -0.0625, 1.0625, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0625, -0.0625, 1.0625, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0625, 1.0625, 1.0625, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0625, 1.0625, -0.0625, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0625, -0.0625, -0.0625, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0625, 0.9375, 1.0625, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0625, 0.9375, -0.0625, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 0.9375, -0.0625, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 0.9375, 1.0625, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 0.0625, 1.0625, (double)tex.func_94212_f(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(-0.0625, 0.0625, -0.0625, (double)tex.func_94212_f(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(1.0625, 0.0625, -0.0625, (double)tex.func_94209_e(), (double)tex.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(1.0625, 0.0625, 1.0625, (double)tex.func_94209_e(), (double)tex.func_94210_h());
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderConnectors(TileEMCCrafterBase tile, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.func_147499_a(MODELTEXTURES[tile.func_145832_p()]);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isCableConnected((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, side)) continue;
            MODEL.renderConnector(side);
        }
        GL11.glPopMatrix();
    }

    private void renderContent(TileEMCCrafterBase tile, double x, double y, double z, float partialTicks) {
        List<ItemStack> stacks = tile.getDisplayStacks();
        float time = (float)Minecraft.func_71410_x().field_71451_h.field_70173_aa + partialTicks;
        if (tile.isCrafting() && tile.maxJobs > 1) {
            float anglePer = 360.0f / (float)tile.maxJobs;
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = stacks.get(i);
                if (stack == null) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.45f), (float)((float)z + 0.5f));
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glRotatef((float)(anglePer * (float)i + time), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.2f, (float)0.0f, (float)0.25f);
                this.renderItem(tile.func_145831_w(), stack, time);
                GL11.glPopMatrix();
            }
        } else {
            ItemStack stack;
            ItemStack itemStack = stack = tile.isCrafting() ? stacks.get(0) : tile.getCurrentTome();
            if (stack != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.3f), (float)((float)z + 0.5f));
                this.renderItem(tile.func_145831_w(), stack, time);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderItem(World world, ItemStack itemStack, float time) {
        EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, itemStack);
        GL11.glRotatef((float)(time % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        entityitem.field_70290_d = 0.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    private boolean isCableConnected(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int tileYPos = y + side.offsetY;
        if (tileYPos < 0 || tileYPos > 256) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x + side.offsetX, tileYPos, z + side.offsetZ);
        if (!(tile instanceof IGridHost) || !(tile instanceof IPartHost)) {
            return false;
        }
        IPartHost host = (IPartHost)tile;
        IPart part = host.getPart(ForgeDirection.UNKNOWN);
        if (part instanceof IPartCable) {
            IPartCable cable = (IPartCable)part;
            return cable.isConnected(side.getOpposite());
        }
        return false;
    }
}

