/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.blocks.condenser.BlockEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.crafter.BlockEMCCrafter;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.items.itemblocks.ItemBlockMulti;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;

public enum BlockEnum {
    EMCCONDENSER("EMCCondenser", (Block)new BlockEMCCondenser(), ItemBlockMulti.class, Predicates.and(Integration.Mods.AE2.getTest(), (Predicate)Predicates.or(Integration.Mods.EE3.getTest(), Integration.Mods.PROJECTE.getTest())), "EMCCondenser", false),
    EMCCRAFTER("EMCCrafter", (Block)new BlockEMCCrafter(), ItemBlockMulti.class, Predicates.and(Integration.Mods.AE2.getTest(), (Predicate)Predicates.or(Integration.Mods.EE3.getTest(), Integration.Mods.PROJECTE.getTest())), "EMCCrafter", false);

    private final String internalName;
    private Block block;
    private Class<? extends ItemBlock> itemBlockClass;
    private boolean enabled = true;
    private boolean hidden;
    private String configKey;
    private Predicate<?> requirements;

    private BlockEnum(String internalName, Block block) {
        this(internalName, block, ItemBlock.class, Predicates.alwaysTrue(), null, false);
    }

    private BlockEnum(String internalName, Block block, Predicate<?> requirements) {
        this(internalName, block, ItemBlock.class, requirements, null, false);
    }

    private BlockEnum(String internalName, Block block, Predicate<?> requirements, String configKey) {
        this(internalName, block, ItemBlock.class, requirements, configKey, false);
    }

    private BlockEnum(String internalName, Block block, String configKey) {
        this(internalName, block, ItemBlock.class, Predicates.alwaysTrue(), configKey, false);
    }

    private BlockEnum(String internalName, Block block, boolean hidden) {
        this(internalName, block, ItemBlock.class, Predicates.alwaysTrue(), null, hidden);
    }

    private BlockEnum(String internalName, Block block, Predicate<?> requirements, boolean hidden) {
        this(internalName, block, ItemBlock.class, requirements, null, hidden);
    }

    private BlockEnum(String internalName, Block block, String configKey, boolean hidden) {
        this(internalName, block, ItemBlock.class, Predicates.alwaysTrue(), configKey, hidden);
    }

    private BlockEnum(String internalName, Block block, Class<? extends ItemBlock> itemBlockClass, Predicate<?> requirements, String configKey, boolean hidden) {
        this.internalName = internalName;
        this.block = block;
        this.block.func_149663_c("equivalentenergistics:" + internalName);
        this.itemBlockClass = itemBlockClass;
        this.requirements = requirements;
        this.configKey = configKey;
        this.hidden = hidden;
    }

    public Block getBlock() {
        return this.block;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return this.itemBlockClass;
    }

    public String getStatName() {
        return StatCollector.func_74838_a((String)(this.block.func_149739_a() + ".name"));
    }

    public Predicate<?> getReqs() {
        return this.requirements;
    }

    public boolean isEnabled() {
        return this.enabled && this.requirements.apply(null);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static void loadConfig(Configuration config) {
        for (BlockEnum current : BlockEnum.values()) {
            if (current.configKey != null) {
                current.enabled = config.get("Blocks", current.configKey, true).getBoolean(true);
            }
            if (current.block instanceof IConfigurable) {
                ((IConfigurable)current.block).loadConfig(config);
            }
            if (!current.isEnabled() || current.isHidden()) continue;
            current.block.func_149647_a(EquivalentEnergistics.tabEE);
        }
    }

    public static void registerBlocks() {
        for (BlockEnum current : BlockEnum.values()) {
            if (!current.isEnabled()) continue;
            GameRegistry.registerBlock((Block)current.getBlock(), current.getItemBlockClass(), (String)current.getInternalName());
        }
    }
}

