/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.asm;

import com.mordenkainen.equivalentenergistics.asm.EqECoreLoader;
import com.mordenkainen.equivalentenergistics.integration.ee3.EquivExchange3;
import java.util.ListIterator;
import java.util.function.BiPredicate;
import moze_intel.projecte.api.item.IItemEmc;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EqECoreTransformer
implements IClassTransformer {
    private static BiPredicate<AbstractInsnNode, Integer> standardTest = (n, i) -> n.getOpcode() == i.intValue();
    private static BiPredicate<AbstractInsnNode, Integer> forgetAllTest = (n, i) -> n.getOpcode() == i.intValue() && ((VarInsnNode)n).var == 0;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("com.pahimar.ee3.knowledge.PlayerKnowledgeRegistry".equals(name)) {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            cr.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                for (patches patch : patches.values()) {
                    if (!methodNode.name.equals(patch.method) || !methodNode.desc.equals(patch.desc)) continue;
                    EqECoreTransformer.applyPatch(methodNode, patch.opcode, patch.test, patch.before, patch.event);
                }
            }
            ClassWriter cw = new ClassWriter(2);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if ("moze_intel.projecte.gameObjs.container.slots.transmutation.SlotLock".equals(name) || "moze_intel.projecte.gameObjs.container.slots.transmutation.SlotInput".equals(name)) {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            cr.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                if (!"func_75214_a".equals(methodNode.name) && !"isItemValid".equals(methodNode.name)) continue;
                ListIterator insnNodes = methodNode.instructions.iterator();
                boolean found = false;
                while (insnNodes.hasNext() && !found) {
                    AbstractInsnNode insn = (AbstractInsnNode)insnNodes.next();
                    if (insn.getOpcode() != 25 || ((VarInsnNode)insn).var != 1) continue;
                    found = true;
                    LabelNode label1 = new LabelNode();
                    InsnList endList = new InsnList();
                    endList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    endList.add((AbstractInsnNode)new JumpInsnNode(198, label1));
                    endList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    endList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", EqECoreLoader.deobf ? "getItem" : "func_77973_b", "()Lnet/minecraft/item/Item;", false));
                    endList.add((AbstractInsnNode)new TypeInsnNode(193, "moze_intel/projecte/api/item/IItemEmc"));
                    endList.add((AbstractInsnNode)new JumpInsnNode(153, label1));
                    endList.add((AbstractInsnNode)new InsnNode(4));
                    endList.add((AbstractInsnNode)new InsnNode(172));
                    endList.add((AbstractInsnNode)label1);
                    methodNode.instructions.insertBefore(insn, endList);
                }
            }
            ClassWriter cw = new ClassWriter(2);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    private static void applyPatch(MethodNode methodNode, int opcode, BiPredicate<AbstractInsnNode, Integer> test, boolean before, String event) {
        ListIterator insnNodes = methodNode.instructions.iterator();
        boolean found = false;
        while (insnNodes.hasNext() && !found) {
            AbstractInsnNode insn = (AbstractInsnNode)insnNodes.next();
            if (!test.test(insn, opcode)) continue;
            found = true;
            InsnList endList = new InsnList();
            endList.add((AbstractInsnNode)new VarInsnNode(25, 1));
            endList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(EquivExchange3.class), event, "(Ljava/lang/String;)V", false));
            if (before) {
                methodNode.instructions.insertBefore(insn, endList);
                continue;
            }
            methodNode.instructions.insert(insn, endList);
        }
    }

    public boolean testfunc(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IItemEmc;
    }

    static /* synthetic */ BiPredicate access$000() {
        return standardTest;
    }

    static /* synthetic */ BiPredicate access$100() {
        return forgetAllTest;
    }

    private static enum patches {
        LEARN("teachPlayer", "(Ljava/lang/String;Ljava/lang/Object;)V", 182, EqECoreTransformer.access$000(), true, "postPlayerLearn"),
        LEARNCOL("teachPlayer", "(Ljava/lang/String;Ljava/util/Collection;)V", 167, EqECoreTransformer.access$000(), false, "postPlayerLearn"),
        FORGET("makePlayerForget", "(Ljava/lang/String;Ljava/lang/Object;)V", 182, EqECoreTransformer.access$000(), true, "postPlayerForget"),
        FORGETCOL("makePlayerForget", "(Ljava/lang/String;Ljava/util/Collection;)V", 167, EqECoreTransformer.access$000(), false, "postPlayerForget"),
        FORGETALL("makePlayerForgetAll", "(Ljava/lang/String;)V", 25, EqECoreTransformer.access$100(), true, "postPlayerForget");

        public String method;
        public String desc;
        public int opcode;
        public BiPredicate<AbstractInsnNode, Integer> test;
        public boolean before;
        public String event;

        private patches(String method, String desc, int opcode, BiPredicate<AbstractInsnNode, Integer> test, boolean before, String event) {
            this.method = method;
            this.desc = desc;
            this.opcode = opcode;
            this.test = test;
            this.before = before;
            this.event = event;
        }
    }
}

