/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.blast.Blast;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastEnderman
extends Blast {
    public int duration = 160;
    private Pos teleportTarget;

    public BlastEnderman(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastEnderman(World world, Entity entity, double x, double y, double z, float size, Pos teleportTarget) {
        super(world, entity, x, y, z, size);
        this.teleportTarget = teleportTarget;
    }

    @Override
    public void doExplode() {
        if (this.oldWorld().field_72995_K) {
            int r = (int)((double)this.getRadius() - (double)this.callCount / (double)this.duration * (double)this.getRadius());
            for (int x = -r; x < r; ++x) {
                for (int z = -r; z < r; ++z) {
                    for (int y = -r; y < r; ++y) {
                        Location targetPosition = (Location)this.position.add((IPos3D)new Pos((double)x, (double)y, (double)z));
                        double distance = targetPosition.distance((IPos3D)this.position);
                        if (!(distance < (double)r) || !(distance > (double)(r - 1)) || targetPosition.getBlock((IBlockAccess)this.oldWorld()) != Blocks.field_150350_a || !((double)this.oldWorld().field_73012_v.nextFloat() < Math.max(0.001 * (double)r, 0.01))) continue;
                        float velX = (float)((targetPosition.x() - this.position.x()) * 0.6);
                        float velY = (float)((targetPosition.y() - this.position.y()) * 0.6);
                        float velZ = (float)((targetPosition.z() - this.position.z()) * 0.6);
                        ICBMClassic.proxy.spawnParticle("portal", this.oldWorld(), (IPos3D)targetPosition, velX, velY, velZ, 5.0f, 1.0);
                    }
                }
            }
        }
        int radius = (int)this.getRadius();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x() - (double)radius), (double)(this.position.y() - (double)radius), (double)(this.position.z() - (double)radius), (double)(this.position.x() + (double)radius), (double)(this.position.y() + (double)radius), (double)(this.position.z() + (double)radius));
        List allEntities = this.oldWorld().func_72872_a(Entity.class, bounds);
        boolean explosionCreated = false;
        for (Entity entity : allEntities) {
            if (entity == this.controller) continue;
            double xDifference = entity.field_70165_t - this.position.x();
            double yDifference = entity.field_70163_u - this.position.y();
            double zDifference = entity.field_70161_v - this.position.z();
            int r = (int)this.getRadius();
            if (xDifference < 0.0) {
                r = (int)(-this.getRadius());
            }
            entity.field_70159_w -= ((double)r - xDifference) * Math.abs(xDifference) * 6.0E-4;
            r = (int)this.getRadius();
            if (entity.field_70163_u > this.position.y()) {
                r = (int)(-this.getRadius());
            }
            entity.field_70181_x += ((double)r - yDifference) * Math.abs(yDifference) * 0.0011;
            r = (int)this.getRadius();
            if (zDifference < 0.0) {
                r = (int)(-this.getRadius());
            }
            entity.field_70179_y -= ((double)r - zDifference) * Math.abs(zDifference) * 6.0E-4;
            Pos pos = new Pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(pos.distance((IPos3D)this.position) < 4.0)) continue;
            if (!explosionCreated && this.callCount % 5 == 0) {
                this.oldWorld().func_72869_a("hugeexplosion", entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
                explosionCreated = true;
            }
            try {
                if (this.teleportTarget == null) {
                    int checkX = this.oldWorld().field_73012_v.nextInt(300) - 150 + (int)this.controller.field_70165_t;
                    int checkZ = this.oldWorld().field_73012_v.nextInt(300) - 150 + (int)this.controller.field_70161_v;
                    int checkY = 63;
                    while (!this.oldWorld().func_147437_c(checkX, checkY, checkZ) && !this.oldWorld().func_147437_c(checkX, checkY + 1, checkZ)) {
                        ++checkY;
                    }
                    this.teleportTarget = new Pos((double)checkX, (double)checkY, (double)checkZ);
                }
                this.oldWorld().func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147364_a(this.teleportTarget.x() + 0.5, this.teleportTarget.y() + 0.5, this.teleportTarget.z() + 0.5, entity.field_70177_z, entity.field_70125_A);
                    continue;
                }
                entity.func_70107_b(this.teleportTarget.x() + 0.5, this.teleportTarget.y() + 0.5, this.teleportTarget.z() + 0.5);
            }
            catch (Exception e) {
                ICBMClassic.INSTANCE.logger().error("Failed to teleport entity to the End.", (Throwable)e);
            }
        }
        this.oldWorld().func_72980_b(this.position.x(), this.position.y(), this.position.z(), "portal.portal", 2.0f, this.oldWorld().field_73012_v.nextFloat() * 0.4f + 0.8f, false);
        if (this.callCount > this.duration) {
            this.controller.endExplosion();
        }
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        if (!this.oldWorld().field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                EntityEnderman enderman = new EntityEnderman(this.oldWorld());
                enderman.func_70107_b(this.position.x(), this.position.y(), this.position.z());
                this.oldWorld().func_72838_d((Entity)enderman);
            }
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getRadius() {
        return 20.0f;
    }

    @Override
    public long getEnergy() {
        return 0L;
    }

    @Override
    public boolean isMovable() {
        return true;
    }
}

