/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive;

import com.builtbroken.mc.framework.explosive.handler.ExplosiveHandler;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.prefab.ModelICBM;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelCustom;
import resonant.api.explosion.IExplosive;

public abstract class Explosive
extends ExplosiveHandler
implements IExplosive {
    private String nameID;
    private int tier;
    private int fuseTime;
    protected boolean isDisabled;
    protected boolean isMobile = false;
    protected boolean hasBlock;
    protected boolean hasGrenade;
    protected boolean hasMinecart;
    protected boolean hasMissile;

    protected Explosive(String name, int tier) {
        super(name);
        this.nameID = name;
        this.tier = tier;
        this.fuseTime = 100;
        this.hasBlock = true;
        this.hasMissile = true;
        this.hasGrenade = this.tier <= 1;
        this.hasMinecart = this.tier <= 2;
        this.isDisabled = false;
    }

    public String getUnlocalizedName() {
        return this.nameID;
    }

    public String getExplosiveName() {
        return LanguageUtility.getLocal((String)("icbm.explosive." + this.nameID + ".name"));
    }

    public String getGrenadeName() {
        return LanguageUtility.getLocal((String)("icbm.grenade." + this.nameID + ".name"));
    }

    public String getMissileName() {
        return LanguageUtility.getLocal((String)("icbm.missile." + this.nameID + ".name"));
    }

    public String getMinecartName() {
        return LanguageUtility.getLocal((String)("icbm.minecart." + this.nameID + ".name"));
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public Explosive setFuseTime(int fuse) {
        this.fuseTime = fuse;
        return this;
    }

    public int getYinXin() {
        return this.fuseTime;
    }

    public void yinZhaQian(World world, Entity entity) {
        world.func_72956_a(entity, "random.fuse", 1.0f, 1.0f);
    }

    public void onYinZha(World world, Pos position, int fuseTicks) {
        world.func_72869_a("smoke", position.x(), position.y() + 0.5, position.z(), 0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelICBM getBlockModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBlockResource() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IModelCustom getMissileModel() {
        return null;
    }

    public boolean hasGrenadeForm() {
        return this.hasGrenade;
    }

    public boolean hasMissileForm() {
        return this.hasMissile;
    }

    public boolean hasMinecartForm() {
        return this.hasMinecart;
    }

    public boolean hasBlockForm() {
        return this.hasBlock;
    }

    public void init() {
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void createExplosion(World world, double x, double y, double z, Entity entity) {
        if (!this.isDisabled) {
            this.doCreateExplosion(world, x, y, z, entity);
        }
    }

    public abstract void doCreateExplosion(World var1, double var2, double var4, double var6, Entity var8);
}

