/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.BluePower;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileDeployer
extends TileBase
implements ISidedInventory,
IEjectAnimator {
    private int animationTimer = -1;
    private final ItemStack[] inventory = new ItemStack[9];
    private static final List<Item> blacklistedItems = new ArrayList<Item>();
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.randomUUID(), "[BP Deployer]");

    @Override
    public void func_145845_h() {
        if (this.animationTimer >= 0 && ++this.animationTimer > 10) {
            this.animationTimer = -1;
        }
    }

    private boolean canDeployItem(ItemStack stack) {
        return stack != null && !blacklistedItems.contains(stack.func_77973_b());
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (!this.field_145850_b.field_72995_K && newValue) {
            ItemStack stack;
            int i;
            this.animationTimer = 0;
            this.sendUpdatePacket();
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)FAKE_PLAYER_PROFILE);
            for (i = 0; i < this.inventory.length; ++i) {
                stack = this.inventory[i];
                player.field_71071_by.func_70299_a(i, stack);
            }
            this.rightClick(player, 9);
            for (i = 0; i < this.inventory.length; ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                this.inventory[i] = stack == null || stack.field_77994_a <= 0 ? null : stack;
                player.field_71071_by.func_70299_a(i, null);
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0) continue;
                ItemStack remainder = IOHelper.insert(this, stack, this.getFacingDirection().getOpposite(), false);
                if (remainder != null) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, remainder));
                }
                player.field_71071_by.func_70299_a(i, null);
            }
        }
    }

    protected boolean rightClick(FakePlayer player, int useItems) {
        if (useItems > 9) {
            throw new IllegalArgumentException("Hotbar is 9 items in width! You're trying " + useItems + "!");
        }
        ForgeDirection faceDir = this.getFacingDirection();
        int dx = faceDir.offsetX;
        int dy = faceDir.offsetY;
        int dz = faceDir.offsetZ;
        int x = this.field_145851_c + dx;
        int y = this.field_145848_d + dy;
        int z = this.field_145849_e + dz;
        player.func_70107_b((double)x + 0.5, (double)y + 0.5 - (double)player.eyeHeight, (double)z + 0.5);
        player.field_70125_A = faceDir.offsetY * -90;
        switch (faceDir) {
            case NORTH: {
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70177_z = -90.0f;
            }
        }
        try {
            ItemStack stack;
            int i;
            EntityLivingBase entity;
            PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_AIR, (int)x, (int)y, (int)z, (int)faceDir.ordinal(), (World)this.field_145850_b);
            if (event.isCanceled()) {
                return false;
            }
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            List detectedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            EntityLivingBase entityLivingBase = entity = detectedEntities.isEmpty() ? null : (EntityLivingBase)detectedEntities.get(this.field_145850_b.field_73012_v.nextInt(detectedEntities.size()));
            if (entity != null) {
                for (i = 0; i < useItems; ++i) {
                    player.field_71071_by.field_70461_c = i;
                    stack = player.func_71045_bC();
                    if (this.canDeployItem(stack) && stack.func_77973_b().func_111207_a(stack, (EntityPlayer)player, entity)) {
                        return true;
                    }
                    if (!(entity instanceof EntityAnimal) || !((EntityAnimal)entity).func_70085_c((EntityPlayer)player)) continue;
                    return true;
                }
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_71045_bC();
                if (!this.canDeployItem(stack) || !stack.func_77973_b().onItemUseFirst(stack, (EntityPlayer)player, this.field_145850_b, x, y, z, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                if (this.field_145850_b.func_147437_c(x, y, x) || !block.func_149727_a(this.field_145850_b, x, y, z, (EntityPlayer)player, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                int useZ;
                player.field_71071_by.field_70461_c = i;
                stack = player.func_71045_bC();
                boolean isGoingToShift = false;
                if (stack != null && (stack.func_77973_b() instanceof ItemReed || stack.func_77973_b() instanceof ItemRedstone)) {
                    isGoingToShift = true;
                }
                int useX = isGoingToShift ? this.field_145851_c : x;
                int useY = isGoingToShift ? this.field_145848_d : y;
                int n = useZ = isGoingToShift ? this.field_145849_e : z;
                if (!this.canDeployItem(stack) || !stack.func_77973_b().func_77648_a(stack, (EntityPlayer)player, this.field_145850_b, useX, useY, useZ, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_71045_bC();
                if (!this.canDeployItem(stack)) continue;
                ItemStack copy = stack.func_77946_l();
                player.func_70062_b(0, stack.func_77973_b().func_77659_a(stack, this.field_145850_b, (EntityPlayer)player));
                if (copy.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            BluePower.log.error("Deployer crashed! Stacktrace: ");
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)tc);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tCompound) {
        super.func_145841_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tc = new NBTTagCompound();
            this.inventory[i].func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound tag) {
        super.writeToPacketNBT(tag);
        tag.func_74757_a("animation", this.animationTimer >= 0);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound tag) {
        super.readFromPacketNBT(tag);
        if (tag.func_74767_n("animation")) {
            this.animationTimer = 0;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return BPBlocks.deployer.func_149739_a();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_94128_d(int var1) {
        ForgeDirection direction = this.getFacingDirection();
        if (var1 == direction.ordinal()) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        for (int i : this.func_94128_d(side)) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        for (int i : this.func_94128_d(side)) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEjecting() {
        return this.animationTimer >= 0;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    static {
        blacklistedItems.add(Items.field_151079_bi);
    }
}

