/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;

public class GateXor
extends GateSimpleDigital {
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentWire w;
    private ShiftingBuffer<Boolean> buf = new ShiftingBuffer(6, 2, (Object)false);

    @Override
    protected void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable();
        ((GateConnectionDigital)this.left()).enable();
    }

    @Override
    protected void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.25, true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 7274677, 0.25, true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 7253479, 0.25, true).setState(true);
        this.addComponent(this.t3);
        this.addComponent(new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).bind((GateConnectionBase)this.front()));
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.w = new GateComponentWire(this, 1630117, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    protected String getGateType() {
        return "xor";
    }

    @Override
    public void doLogic() {
        this.buf.set(0, (Object)((GateConnectionDigital)this.left()).getInput());
        this.buf.set(1, (Object)((GateConnectionDigital)this.right()).getInput());
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.buf.shift();
        ((GateConnectionDigital)this.front()).setOutput(this.t1.getState() || this.t2.getState());
        this.t3.setState((Boolean)this.buf.get(0) == false && (Boolean)this.buf.get(1) == false);
        this.w.setPower((byte)(this.t3.getState() ? 255 : 0));
        this.t1.setState((Boolean)this.buf.get(0) == false && !this.t3.getState());
        this.t2.setState((Boolean)this.buf.get(1) == false && !this.t3.getState());
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.buf.readFromNBT(tag, "buffer");
    }
}

