/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponentCubes;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.wire.redstone.WireHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class GateComponentWire
extends GateComponentCubes {
    private RedwireType type;
    private GateConnectionBase connection;
    private byte power;
    private boolean enabled = true;

    public GateComponentWire(GateBase<?, ?, ?, ?, ?, ?> gate, int color, RedwireType type) {
        super(gate, color);
        this.type = type;
    }

    @Override
    public int getColor() {
        byte power = this.getPower();
        int colorMin = this.isEnabled() ? this.type.getMinColor() : 0x6A6A6A;
        int colorMax = this.isEnabled() ? this.type.getMaxColor() : 0x6A6A6A;
        return WireHelper.getColorForPowerLevel(colorMin, colorMax, power);
    }

    @Override
    public IIcon getIcon() {
        return IconSupplier.wire;
    }

    @Override
    public double getHeight() {
        return 0.03125;
    }

    public GateComponentWire bind(GateConnectionBase connection) {
        this.connection = connection;
        return this;
    }

    public GateComponentWire setPower(byte power) {
        if (power != this.power) {
            this.setNeedsSyncing(true);
        }
        this.power = power;
        return this;
    }

    public byte getPower() {
        if (this.connection != null && this.getGate().getParent() != null && ((BPPart)((Object)this.getGate())).getWorld() != null && (this.getGate().getParent().isSimulated() || !((BPPart)((Object)this.getGate())).getWorld().field_72995_K)) {
            if (this.connection.isEnabled()) {
                return (byte)(this.connection.getSignal() * 255.0);
            }
            return 127;
        }
        return this.power;
    }

    public boolean isEnabled() {
        if (this.connection != null && this.getGate().getParent() != null && ((BPPart)((Object)this.getGate())).getWorld() != null && (this.getGate().getParent().isSimulated() || !((BPPart)((Object)this.getGate())).getWorld().field_72995_K)) {
            return this.connection.isEnabled();
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.setNeedsSyncing(true);
        }
        this.enabled = enabled;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("power", this.getPower());
        tag.func_74757_a("enabled", this.isEnabled());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74771_c("power");
        this.enabled = tag.func_74767_n("enabled");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeByte(this.getPower());
        buffer.writeBoolean(this.isEnabled());
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.power = buffer.readByte();
        this.enabled = buffer.readBoolean();
    }

    @Override
    public boolean needsSyncing() {
        if (this.connection != null && this.connection.needsSyncing()) {
            return true;
        }
        return super.needsSyncing();
    }
}

