/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.IIcon;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Scale;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec2dRect;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class GateComponentCubes
extends GateComponent {
    protected int layoutColor = -1;
    private List<Vec3dCube> cubes = new ArrayList<Vec3dCube>();

    public GateComponentCubes(GateBase<?, ?, ?, ?, ?, ?> gate, int color) {
        super(gate);
        this.layoutColor = color;
        this.onLayoutRefresh();
    }

    protected List<Vec3dCube> getCubes() {
        return this.cubes;
    }

    @Override
    public void onLayoutRefresh() {
        if (this.layoutColor == -1) {
            return;
        }
        this.cubes.clear();
        double height = this.getHeight();
        double scale = 1.0 / (double)((GateBase)this.getGate()).getLayout().getLayout(this.layoutColor).getWidth();
        Scale transformation = new Scale(scale, 1.0, scale);
        for (Rectangle r : ((GateBase)this.getGate()).getLayout().getSimplifiedLayout(this.layoutColor).getRectangles()) {
            this.cubes.add(new Vec2dRect(r).extrude(height).transform((Transformation)transformation).add(-0.484375, 0.125, -0.484375));
        }
    }

    @Override
    public void renderStatic(Vec3i translation, RenderHelper renderer, int pass) {
        renderer.setColor(this.getColor());
        renderer.setRenderSides(false, true, true, true, true, true);
        for (Vec3dCube c : this.getCubes()) {
            renderer.renderBox(c, this.getIcon());
        }
        renderer.resetRenderedSides();
        renderer.setColor(0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return null;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public double getHeight() {
        return 0.0;
    }
}

