/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LocationCache<CachedType> {
    private final CachedType[] cachedValue;

    public LocationCache(World world, int x, int y, int z, Object ... extraArgs) {
        if (world == null) {
            throw new NullPointerException("World can't be null!");
        }
        this.cachedValue = new Object[6];
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.cachedValue[d.ordinal()] = this.getNewValue(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, extraArgs);
        }
    }

    protected abstract CachedType getNewValue(World var1, int var2, int var3, int var4, Object ... var5);

    public CachedType getValue(ForgeDirection side) {
        return this.cachedValue[side.ordinal()];
    }
}

