/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceSolar
extends TileEntityBase
implements IEnergyProvider,
IEnergySaver,
IEnergyDisplay {
    public static final int PRODUCE = 8;
    public EnergyStorage storage = new EnergyStorage(30000);
    private int oldEnergy;

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hasBlockAbove() && this.field_145850_b.func_72935_r() && 8 <= this.getMaxEnergyStored(ForgeDirection.UNKNOWN) - this.getEnergyStored(ForgeDirection.UNKNOWN)) {
                this.storage.receiveEnergy(8, false);
                this.func_70296_d();
            }
            if (this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.storage);
                WorldUtil.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.storage);
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
    }

    public boolean hasBlockAbove() {
        for (int y = this.field_145848_d + 1; y <= this.field_145850_b.func_72800_K(); ++y) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, y, this.field_145849_e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

