/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.items.lens.Lenses;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAtomicReconstructor
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver,
IRedstoneToggle,
IEnergyDisplay,
IAtomicReconstructor {
    public static final int ENERGY_USE = 1000;
    public EnergyStorage storage = new EnergyStorage(300000);
    private int currentTime;
    private boolean activateOnceWithSignal;
    private int oldEnergy;

    public TileEntityAtomicReconstructor() {
        super(1, "reconstructor");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.activateOnceWithSignal) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 100;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 1000) {
            ForgeDirection sideToManipulate = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.storage.extractEnergy(1000, false);
            Lens currentLens = this.getCurrentLens();
            int distance = currentLens.getDistance();
            for (int i = 0; i < distance; ++i) {
                Position hitBlock = WorldUtil.getCoordsFromSide(sideToManipulate, this.field_145851_c, this.field_145848_d, this.field_145849_e, i);
                if (currentLens.invoke(hitBlock, this)) {
                    this.shootLaser(hitBlock.getX(), hitBlock.getY(), hitBlock.getZ(), currentLens);
                    break;
                }
                if (i < distance - 1) continue;
                this.shootLaser(hitBlock.getX(), hitBlock.getY(), hitBlock.getZ(), currentLens);
            }
        }
    }

    public Lens getCurrentLens() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ILensItem) {
            return ((ILensItem)this.slots[0].func_77973_b()).getLens();
        }
        return Lenses.LENS_NONE;
    }

    private void shootLaser(int endX, int endY, int endZ, Lens currentLens) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, ModUtil.MOD_ID_LOWER + ":reconstructor", 0.35f, 1.0f);
        PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketParticle(this.field_145851_c, this.field_145848_d, this.field_145849_e, endX, endY, endZ, currentLens.getColor(), 8, 2.0f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("CurrentTime", this.currentTime);
        this.storage.writeToNBT(compound);
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.currentTime = compound.func_74762_e("CurrentTime");
        this.storage.readFromNBT(compound);
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        this.sendUpdate();
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        this.sendUpdate();
        return super.func_70298_a(i, j);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ILensItem;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public void extractEnergy(int amount) {
        this.storage.extractEnergy(amount, false);
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

