/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import cpw.mods.fml.common.registry.GameRegistry;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.creative.CreativeTab;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class BlockContainerBase
extends BlockContainer {
    private String name;

    public BlockContainerBase(Material material, String name) {
        super(material);
        this.name = name;
        this.register();
    }

    private void register() {
        this.func_149663_c(ModUtil.MOD_ID_LOWER + "." + this.getBaseName());
        GameRegistry.registerBlock((Block)this, this.getItemBlock(), (String)this.getBaseName());
        if (this.shouldAddCreative()) {
            this.func_149647_a(CreativeTab.instance);
        } else {
            this.func_149647_a(null);
        }
    }

    protected String getBaseName() {
        return this.name;
    }

    protected Class<? extends ItemBlockBase> getItemBlock() {
        return ItemBlockBase.class;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.common;
    }

    public void dropInventory(World world, int x, int y, int z) {
        TileEntityInventoryBase tile;
        TileEntity aTile;
        if (!world.field_72995_K && (aTile = world.func_147438_o(x, y, z)) instanceof TileEntityInventoryBase && (tile = (TileEntityInventoryBase)aTile).func_70302_i_() > 0) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                this.dropSlotFromInventory(i, tile, world, x, y, z);
            }
        }
    }

    public void dropSlotFromInventory(int i, TileEntityInventoryBase tile, World world, int x, int y, int z) {
        ItemStack stack = tile.func_70301_a(i);
        if (stack != null && stack.field_77994_a > 0) {
            float dX = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            float dY = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            float dZ = Util.RANDOM.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), stack.func_77946_l());
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = Util.RANDOM.nextGaussian() * (double)factor;
            entityItem.field_70181_x = Util.RANDOM.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = Util.RANDOM.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
        tile.func_70299_a(i, null);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.updateRedstoneState(world, x, y, z);
    }

    public void updateRedstoneState(World world, int x, int y, int z) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityBase) {
            boolean powered = world.func_72864_z(x, y, z);
            boolean wasPowered = ((TileEntityBase)tile).isRedstonePowered;
            if (powered && !wasPowered) {
                if (tile instanceof IRedstoneToggle && ((IRedstoneToggle)tile).isPulseMode()) {
                    world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
                }
                ((TileEntityBase)tile).setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                ((TileEntityBase)tile).setRedstonePowered(false);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof IRedstoneToggle && ((IRedstoneToggle)tile).isPulseMode()) {
            ((IRedstoneToggle)tile).activateOnPulse();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            int amount;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IEnergySaver) {
                ((IEnergySaver)tile).setEnergy(stack.func_77978_p().func_74762_e("Energy"));
            }
            if (tile instanceof IFluidSaver && (amount = stack.func_77978_p().func_74762_e("FluidAmount")) > 0) {
                FluidStack[] fluids = new FluidStack[amount];
                for (int i = 0; i < amount; ++i) {
                    NBTTagCompound compound = stack.func_77978_p().func_74775_l("Fluid" + i);
                    if (compound == null) continue;
                    fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                }
                ((IFluidSaver)tile).setFluids(fluids);
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, meta, 0);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            FluidStack[] fluids;
            int energy;
            ItemStack stack = new ItemStack(this.func_149650_a(metadata, Util.RANDOM, fortune), 1, this.func_149692_a(metadata));
            if (tile instanceof IEnergySaver && (energy = ((IEnergySaver)tile).getEnergy()) > 0) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("Energy", energy);
            }
            if (tile instanceof IFluidSaver && (fluids = ((IFluidSaver)tile).getFluids()) != null && fluids.length > 0) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("FluidAmount", fluids.length);
                for (int i = 0; i < fluids.length; ++i) {
                    if (fluids[i] == null || fluids[i].amount <= 0) continue;
                    NBTTagCompound compound = new NBTTagCompound();
                    fluids[i].writeToNBT(compound);
                    stack.func_77978_p().func_74782_a("Fluid" + i, (NBTBase)compound);
                }
            }
            drops.add(stack);
        }
        return drops;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateRedstoneState(world, x, y, z);
    }

    public boolean tryToggleRedstone(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockRedstoneTorch && (tile = world.func_147438_o(x, y, z)) instanceof IRedstoneToggle) {
            if (!world.field_72995_K) {
                ((IRedstoneToggle)tile).toggle(!((IRedstoneToggle)tile).isPulseMode());
                tile.func_70296_d();
                if (tile instanceof TileEntityBase) {
                    ((TileEntityBase)tile).sendUpdate();
                }
            }
            return true;
        }
        return false;
    }
}

