package io.darkcraft.darkcore.mod.proxy;

import io.darkcraft.darkcore.mod.handlers.packets.ProxyHandler;
import io.darkcraft.darkcore.mod.nbt.NBTHelper;
import io.darkcraft.darkcore.mod.nbt.NBTProperty;
import java.lang.Override;
import java.lang.String;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public final class CommonProxyImpl extends CommonProxy {
  @Override
  public void test() {
    NBTTagCompound tag = new NBTTagCompound();
    tag.setString("method", "test");
    tag.setString("myClass", "io.darkcraft.darkcore.mod.proxy.CommonProxy");
    ProxyHandler.sendToAll(tag);
  }

  @Override
  public void testDimension(int dim, String par1) {
    NBTTagCompound tag = NBTHelper.serialise(NBTProperty.SerialisableType.TRANSMIT, dim, par1);
    tag.setString("method", "testDimension");
    tag.setString("myClass", "io.darkcraft.darkcore.mod.proxy.CommonProxy");
    ProxyHandler.sendToDimension(dim, tag);
  }

  @Override
  public void testPlayer(EntityPlayerMP test, String par2, int test3) {
    NBTTagCompound tag = NBTHelper.serialise(NBTProperty.SerialisableType.TRANSMIT, test, par2, test3);
    tag.setString("method", "testPlayer");
    tag.setString("myClass", "io.darkcraft.darkcore.mod.proxy.CommonProxy");
    ProxyHandler.sendToPlayer(test, tag);
  }
}
