/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.api.core.nbt.INBTItemSerializable;
import growthcraft.core.common.tileentity.GrcTileBase;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.util.ItemUtils;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.struct.Cheese;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCheeseBlock
extends GrcTileBase
implements IItemHandler,
INBTItemSerializable {
    private Cheese cheese = new Cheese();

    public List<ItemStack> populateDrops(List<ItemStack> list) {
        ItemStack stack;
        if (this.cheese.isAged() && (stack = this.cheese.asFullStack()) != null) {
            list.add(stack);
        }
        return list;
    }

    public Cheese getCheese() {
        return this.cheese;
    }

    public int getCheeseId() {
        return this.getCheese().getId();
    }

    public int getCheeseStageId() {
        return this.getCheese().getStageId();
    }

    protected void readCheeseFromNBT(NBTTagCompound nbt) {
        this.cheese.readFromNBT(nbt);
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readCheeseFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheeseBlock(NBTTagCompound nbt) {
        this.readCheeseFromNBT(nbt);
    }

    protected void writeCheeseToNBT(NBTTagCompound nbt) {
        this.cheese.writeToNBT(nbt);
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeCheeseToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheeseBlock(NBTTagCompound nbt) {
        this.writeCheeseToNBT(nbt);
    }

    public ItemStack asItemStack() {
        ItemStack stack = GrowthCraftMilk.blocks.cheeseBlock.asStack();
        NBTTagCompound tag = ItemBlockCheeseBlock.openNBT(stack);
        this.writeToNBTForItem(tag);
        return stack;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.readFromStream(stream);
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.writeToStream(stream);
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.cheese.update();
            if (this.cheese.needClientUpdate) {
                this.cheese.needClientUpdate = false;
                if (this.cheese.hasSlices()) {
                    this.markForUpdate();
                } else {
                    this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    @Override
    public boolean tryPlaceItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        return this.cheese.tryWaxing(onHand);
    }

    @Override
    public boolean tryTakeItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        if (this.cheese.isAged()) {
            ItemStack stack = this.cheese.yankSlices(1, true);
            if (stack != null) {
                ItemUtils.addStackToPlayer(stack, player, false);
            }
            this.cheese.needClientUpdate |= true;
            return true;
        }
        return false;
    }
}

