/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.integration.NEI;
import growthcraft.core.util.MapGenHelper;
import growthcraft.hops.GrcHopsConfig;
import growthcraft.hops.common.CommonProxy;
import growthcraft.hops.common.village.ComponentVillageHopVineyard;
import growthcraft.hops.common.village.VillageHandlerHops;
import growthcraft.hops.init.GrcHopsBlocks;
import growthcraft.hops.init.GrcHopsFluids;
import growthcraft.hops.init.GrcHopsItems;
import growthcraft.hops.integration.ForestryModule;
import growthcraft.hops.integration.MFRModule;
import growthcraft.hops.integration.ThaumcraftModule;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Growthcraft|Hops", name="Growthcraft Hops", version="1.7.10-2.7.2", dependencies="required-after:Growthcraft@1.7.10-2.7.2;required-after:Growthcraft|Cellar@1.7.10-2.7.2")
public class GrowthCraftHops {
    public static final String MOD_ID = "Growthcraft|Hops";
    public static final String MOD_NAME = "Growthcraft Hops";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    @Mod.Instance(value="Growthcraft|Hops")
    public static GrowthCraftHops instance;
    public static final GrcHopsBlocks blocks;
    public static final GrcHopsItems items;
    public static final GrcHopsFluids fluids;
    private final ILogger logger = new GrcLogger("Growthcraft|Hops");
    private final GrcHopsConfig config = new GrcHopsConfig();
    private final ModuleContainer modules = new ModuleContainer();

    public static GrcHopsConfig getConfig() {
        return GrowthCraftHops.instance.config;
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/hops.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        this.modules.preInit();
        this.register();
    }

    private void register() {
        this.modules.register();
        CoreRegistry.instance().vineDrops().addDropEntry(GrowthCraftHops.items.hops.asStack(2), this.config.hopsVineDropRarity);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(new WeightedRandomChestContent(GrowthCraftHops.items.hops.asStack(), 1, 2, 10));
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(new WeightedRandomChestContent(GrowthCraftHops.items.hops.asStack(), 1, 2, 10));
        MapGenHelper.registerVillageStructure(ComponentVillageHopVineyard.class, "grc.hopvineyard");
        OreDictionary.registerOre((String)"cropHops", GrowthCraftHops.items.hops.getItem());
        OreDictionary.registerOre((String)"materialHops", GrowthCraftHops.items.hops.getItem());
        OreDictionary.registerOre((String)"conesHops", GrowthCraftHops.items.hops.getItem());
        OreDictionary.registerOre((String)"seedHops", GrowthCraftHops.items.hopSeeds.getItem());
        OreDictionary.registerOre((String)"listAllseed", GrowthCraftHops.items.hopSeeds.getItem());
        GameRegistry.addShapelessRecipe((ItemStack)GrowthCraftHops.items.hopSeeds.asStack(), (Object[])new Object[]{GrowthCraftHops.items.hops.getItem()});
        NEI.hideItem(GrowthCraftHops.blocks.hopVine.asStack());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void initVillageHandlers() {
        VillageHandlerHops handler = new VillageHandlerHops();
        int brewerID = GrowthCraftCellar.getConfig().villagerBrewerID;
        if (brewerID > 0) {
            VillagerRegistry.instance().registerVillageTradeHandler(brewerID, (VillagerRegistry.IVillageTradeHandler)handler);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (Booze bz : GrowthCraftHops.fluids.hopAleBooze) {
                bz.setIcons(GrowthCraftCore.liquidSmoothTexture);
            }
            for (Booze bz : GrowthCraftHops.fluids.lagerBooze) {
                bz.setIcons(GrowthCraftCore.liquidSmoothTexture);
            }
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent event) {
        this.modules.postInit();
    }

    static {
        blocks = new GrcHopsBlocks();
        items = new GrcHopsItems();
        fluids = new GrcHopsFluids();
    }
}

