/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private RenderUtils() {
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void resetScale() {
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void startInventoryRender() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.resetColor();
        RenderUtils.resetScale();
    }

    public static void endInventoryRender() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawCubeFace(Face face, Block block, RenderBlocks renderer, Tessellator tes, IIcon icon, double i, double j, double k) {
        float f = 0.0f;
        switch (face) {
            case XPOS: {
                tes.func_78372_c(-0.0f, 0.0f, 0.0f);
                tes.func_78375_b(1.0f, 0.0f, 0.0f);
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                renderer.func_147764_f(block, i, j, k, icon);
                break;
            }
            case XNEG: {
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                tes.func_78375_b(-1.0f, 0.0f, 0.0f);
                tes.func_78372_c(-0.0f, 0.0f, 0.0f);
                renderer.func_147798_e(block, i, j, k, icon);
                break;
            }
            case YPOS: {
                tes.func_78372_c(0.0f, -0.0f, 0.0f);
                tes.func_78375_b(0.0f, 1.0f, 0.0f);
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                renderer.func_147806_b(block, i, j, k, icon);
                break;
            }
            case YNEG: {
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                tes.func_78375_b(0.0f, -1.0f, 0.0f);
                tes.func_78372_c(0.0f, -0.0f, 0.0f);
                renderer.func_147768_a(block, i, j, k, icon);
                break;
            }
            case ZPOS: {
                tes.func_78372_c(0.0f, 0.0f, -0.0f);
                tes.func_78375_b(0.0f, 0.0f, 1.0f);
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                renderer.func_147734_d(block, i, j, k, icon);
                break;
            }
            case ZNEG: {
                tes.func_78372_c(0.0f, 0.0f, 0.0f);
                tes.func_78375_b(0.0f, 0.0f, -1.0f);
                tes.func_78372_c(0.0f, 0.0f, -0.0f);
                renderer.func_147761_c(block, i, j, k, icon);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid face value " + (Object)((Object)face) + ".");
            }
        }
    }

    public static void drawFace(Face face, Block block, RenderBlocks renderer, Tessellator tessellator, IIcon icon, double i, double j, double k) {
        tessellator.func_78382_b();
        RenderUtils.drawCubeFace(face, block, renderer, tessellator, icon, i, j, k);
        tessellator.func_78381_a();
    }

    public static void renderInventoryBlockOverride(Block block, RenderBlocks renderer, IIcon[] icon, Tessellator tessellator) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        RenderUtils.drawCubeFace(Face.YNEG, block, renderer, tessellator, icon[0], 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.YPOS, block, renderer, tessellator, icon[1], 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZNEG, block, renderer, tessellator, icon[2], 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZPOS, block, renderer, tessellator, icon[3], 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XNEG, block, renderer, tessellator, icon[4], 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XPOS, block, renderer, tessellator, icon[5], 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderInventoryBlockFaces(Block block, int meta, RenderBlocks renderer, Tessellator tessellator) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        RenderUtils.drawCubeFace(Face.YNEG, block, renderer, tessellator, block.func_149691_a(0, meta), 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.YPOS, block, renderer, tessellator, block.func_149691_a(1, meta), 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZNEG, block, renderer, tessellator, block.func_149691_a(2, meta), 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZPOS, block, renderer, tessellator, block.func_149691_a(3, meta), 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XNEG, block, renderer, tessellator, block.func_149691_a(4, meta), 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XPOS, block, renderer, tessellator, block.func_149691_a(5, meta), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderInventoryBlock(Block block, int meta, RenderBlocks renderer, Tessellator tessellator) {
        RenderUtils.renderInventoryBlockFaces(block, meta, renderer, tessellator);
    }

    public static void drawInventoryBlock_icon(Block block, RenderBlocks renderer, IIcon icon, Tessellator tessellator) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        RenderUtils.drawCubeFace(Face.YNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.YPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.ZPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XNEG, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        RenderUtils.drawCubeFace(Face.XPOS, block, renderer, tessellator, icon, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void drawCrossSquaresAlongX(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV) {
        tessellator.func_78374_a(minX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(minX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, minZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, minY, minZ, minU, maxV);
    }

    public static void drawCrossSquaresAlongY(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV) {
        tessellator.func_78374_a(maxX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, minZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(minX, minY, minZ, minU, maxV);
    }

    public static void drawCrossSquaresAlongYRotated(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV) {
        tessellator.func_78374_a(minX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(minX, maxY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, minY, maxZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, maxY, minZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, minU, maxV);
    }

    public static void drawCrossSquaresAlongZ(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV) {
        tessellator.func_78374_a(maxX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, minZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, maxZ, maxU, maxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, minZ, minU, minV);
        tessellator.func_78374_a(minX, minY, minZ, minU, maxV);
    }

    public static enum Face {
        XPOS,
        XNEG,
        YPOS,
        YNEG,
        ZPOS,
        ZNEG;

        public static final Face[] FACES;

        static {
            FACES = new Face[]{YNEG, YPOS, ZNEG, ZPOS, XNEG, XPOS};
        }
    }
}

