/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.init;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.GrcModuleBlocks;
import growthcraft.core.common.block.BlockFenceRope;
import growthcraft.core.common.block.BlockRope;
import growthcraft.core.common.block.BlockSaltBlock;
import growthcraft.core.common.definition.BlockDefinition;
import growthcraft.core.common.item.ItemBlockFenceRope;
import growthcraft.core.common.item.ItemBlockNaturaFenceRope;
import growthcraft.core.integration.NEI;
import growthcraft.core.integration.minecraft.EnumMinecraftWoodType;
import growthcraft.core.registry.FenceRopeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

public class GrcCoreBlocks
extends GrcModuleBlocks {
    public BlockDefinition ropeBlock;
    public BlockDefinition saltBlock;
    public BlockDefinition fenceRope;
    public BlockDefinition netherBrickFenceRope;
    public BlockDefinition naturaFenceRope;
    public Map<EnumMinecraftWoodType, BlockDefinition> etfuturumFenceRopes = new HashMap<EnumMinecraftWoodType, BlockDefinition>();
    public Map<String, BlockDefinition> woodstuffFenceRopes = new HashMap<String, BlockDefinition>();

    @Override
    public void preInit() {
        this.saltBlock = this.newDefinition(new BlockSaltBlock());
        this.ropeBlock = this.newDefinition(new BlockRope());
        this.fenceRope = this.newDefinition(new BlockFenceRope(Blocks.field_150422_aJ, "grc.fenceRope"));
        this.netherBrickFenceRope = this.newDefinition(new BlockFenceRope(Blocks.field_150386_bk, "grc.netherBrickFenceRope"));
        FenceRopeRegistry.instance().addEntry(Blocks.field_150422_aJ, (Block)this.fenceRope.getBlock());
        FenceRopeRegistry.instance().addEntry(Blocks.field_150386_bk, (Block)this.netherBrickFenceRope.getBlock());
    }

    @Override
    public void register() {
        this.fenceRope.register("grc.fenceRope", ItemBlockFenceRope.class);
        this.ropeBlock.register("grc.ropeBlock");
        this.saltBlock.register("grccore.salt_block");
        this.netherBrickFenceRope.register("grc.netherBrickFenceRope", ItemBlockFenceRope.class);
        Blocks.field_150480_ab.setFireInfo(this.fenceRope.getBlock(), 5, 20);
    }

    private void initEtfuturum() {
        String modId = "etfuturum";
        if (Loader.isModLoaded((String)"etfuturum")) {
            String[] woodTypes;
            for (String woodTypeName : woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"}) {
                Block block = GameRegistry.findBlock((String)"etfuturum", (String)("fence_" + woodTypeName));
                if (block == null) continue;
                String basename = "grc.etfuturum_fence_rope_" + woodTypeName;
                BlockDefinition fp = this.newDefinition(new BlockFenceRope(block, basename));
                fp.register(basename, ItemBlockFenceRope.class);
                Blocks.field_150480_ab.setFireInfo(fp.getBlock(), 5, 20);
                FenceRopeRegistry.instance().addEntry(block, (Block)fp.getBlock());
                NEI.hideItem(fp.asStack());
            }
        }
    }

    private void initWoodstuff() {
        String modId = "woodstuff";
        if (Loader.isModLoaded((String)"woodstuff")) {
            String[] stringArray = new String[]{"skyrootPlank", "planksWitchwood", "planks", "livingwood", "dreamwood", "wood0", "enhancedbiomes.tile.planksEB", "planks", "planks_scorched", "planks_varnished", "petrifiedWoodPlanks", "planks", "planks", "hl_woodPlanks", "planks", "RidiculousPlanks", "blockWoodenDevice", "redCedarPlank", "tile.TFTowerStone", "witchwood"};
        }
    }

    private void initNatura() {
        Block block;
        String modId = "Natura";
        if (Loader.isModLoaded((String)"Natura") && (block = GameRegistry.findBlock((String)"Natura", (String)"Natura.fence")) != null) {
            this.naturaFenceRope = this.newDefinition(new BlockFenceRope(block, "grc.naturaFenceRope"));
            this.naturaFenceRope.register("grc.naturaFenceRope", ItemBlockNaturaFenceRope.class);
            Blocks.field_150480_ab.setFireInfo(this.naturaFenceRope.getBlock(), 5, 20);
            FenceRopeRegistry.instance().addEntry(block, (Block)this.naturaFenceRope.getBlock());
            NEI.hideItem(this.naturaFenceRope.asStack());
        }
    }

    @Override
    public void init() {
        OreDictionary.registerOre((String)"blockSalt", (Item)this.saltBlock.getItem());
        if (GrowthCraftCore.getConfig().enableEtfuturumIntegration) {
            this.initEtfuturum();
        }
        if (GrowthCraftCore.getConfig().enableWoodstuffIntegration) {
            this.initWoodstuff();
        }
        if (GrowthCraftCore.getConfig().enableNaturaIntegration) {
            this.initNatura();
        }
        NEI.hideItem(this.fenceRope.asStack());
        NEI.hideItem(this.netherBrickFenceRope.asStack());
        NEI.hideItem(this.ropeBlock.asStack());
    }
}

