/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.common.inventory.slot.SlotInput;
import growthcraft.core.common.inventory.slot.SlotPlayer;
import growthcraft.core.common.inventory.slot.SlotPlayerBackpack;
import growthcraft.core.common.inventory.slot.SlotPlayerHotbar;
import growthcraft.core.common.tileentity.feature.IGuiNetworkSync;
import growthcraft.core.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GrcContainer
extends Container {
    protected static final int SLOT_W = 18;
    protected static final int SLOT_H = 18;
    protected TileEntity tileEntity;

    public GrcContainer(TileEntity te) {
        this.tileEntity = te;
    }

    public boolean mergeWithSlot(Slot slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            return false;
        }
        return slot.func_75214_a(stack) && this.func_75135_a(stack, slot.field_75222_d, slot.field_75222_d + 1, false);
    }

    public boolean mergeWithSlotsOfKind(ItemStack stack, Class<? extends Slot> slotClass) {
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            return false;
        }
        int start = -1;
        int end = -1;
        for (Object sub : this.field_75151_b) {
            if (!slotClass.isInstance(sub)) continue;
            Slot subSlot = (Slot)sub;
            if (start < 0) {
                start = subSlot.field_75222_d;
            }
            end = subSlot.field_75222_d;
        }
        if (start <= -1 || end <= -1) {
            return false;
        }
        boolean merged = false;
        for (int i = start; i < end && stack.field_77994_a > 0; ++i) {
            Object obj = this.field_75151_b.get(i);
            if (!slotClass.isInstance(obj)) continue;
            Slot subSlot = (Slot)obj;
            merged |= this.mergeWithSlot(subSlot, stack);
        }
        return merged;
    }

    public boolean mergeWithPlayer(ItemStack stack) {
        return this.mergeWithSlotsOfKind(stack, SlotPlayer.class);
    }

    public boolean mergeWithPlayerHotbar(ItemStack stack) {
        return this.mergeWithSlotsOfKind(stack, SlotPlayerHotbar.class);
    }

    public boolean mergeWithPlayerBackpack(ItemStack stack) {
        return this.mergeWithSlotsOfKind(stack, SlotPlayerBackpack.class);
    }

    public boolean mergeWithInput(ItemStack stack) {
        return this.mergeWithSlotsOfKind(stack, SlotInput.class);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        if (Platform.isClient()) {
            return null;
        }
        Slot s = this.func_75139_a(index);
        ItemStack itemstack = null;
        if (s != null && s.func_75216_d()) {
            ItemStack stack = s.func_75211_c();
            itemstack = stack.func_77946_l();
            boolean wasMerged = false;
            if (s instanceof SlotPlayer) {
                if (!(wasMerged |= this.mergeWithInput(stack))) {
                    if (s instanceof SlotPlayerHotbar) {
                        wasMerged |= this.mergeWithPlayerBackpack(stack);
                    } else if (s instanceof SlotPlayerBackpack) {
                        wasMerged |= this.mergeWithPlayerHotbar(stack);
                    }
                }
            } else {
                wasMerged |= this.mergeWithPlayer(stack);
            }
            if (!wasMerged) {
                return null;
            }
            s.func_75220_a(stack, itemstack);
            if (stack.field_77994_a <= 0) {
                s.func_75215_d((ItemStack)null);
            }
            s.func_75218_e();
            if (stack.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            s.func_82870_a(player, stack);
        }
        return itemstack;
    }

    public void bindPlayerHotbar(IInventory playerInventory, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPlayerHotbar(playerInventory, i, x + i * 18, y));
        }
    }

    public void bindPlayerBackpack(IInventory playerInventory, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotIndex = 9 + col + row * 9;
                this.func_75146_a(new SlotPlayerBackpack(playerInventory, slotIndex, x + col * 18, y + row * 18));
            }
        }
    }

    public void bindPlayerInventory(IInventory playerInventory, int x, int y) {
        this.bindPlayerBackpack(playerInventory, x, y);
        this.bindPlayerHotbar(playerInventory, x, y + 58);
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.tileEntity instanceof IInventory) {
            return ((IInventory)this.tileEntity).func_70300_a(player);
        }
        return false;
    }

    public void func_75132_a(ICrafting iCrafting) {
        super.func_75132_a(iCrafting);
        if (this.tileEntity instanceof IGuiNetworkSync) {
            ((IGuiNetworkSync)this.tileEntity).sendGUINetworkData(this, iCrafting);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.tileEntity instanceof IGuiNetworkSync) {
            IGuiNetworkSync sync = (IGuiNetworkSync)this.tileEntity;
            for (Object crafter : this.field_75149_d) {
                if (!(crafter instanceof ICrafting)) continue;
                sync.sendGUINetworkData(this, (ICrafting)crafter);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int v) {
        super.func_75137_b(id, v);
        if (this.tileEntity instanceof IGuiNetworkSync) {
            ((IGuiNetworkSync)this.tileEntity).receiveGUINetworkData(id, v);
        }
    }
}

