/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.fluids.CellarTank;
import growthcraft.cellar.common.inventory.ContainerFruitPress;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.FruitPress;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityFruitPress
extends TileEntityCellarDevice
implements ITileProgressiveDevice {
    private static final int[] allSlotIds = new int[]{0, 1};
    private static final int[] residueSlotIds = new int[]{0};
    private FruitPress fruitPress = new FruitPress(this, 0, 0, 1);

    @Override
    protected FluidTank[] createTanks() {
        int maxCap = GrowthCraftCellar.getConfig().fruitPressMaxCap;
        return new FluidTank[]{new CellarTank(maxCap, this)};
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 2);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.fruitPress";
    }

    @Override
    public String getGuiID() {
        return "grccellar:fruit_press";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFruitPress(playerInventory, this);
    }

    @Override
    public float getDeviceProgress() {
        return this.fruitPress.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.fruitPress.getProgressScaled(scale);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.fruitPress.update();
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return allSlotIds;
    }

    @Override
    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return index == 0;
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return index == 0 ? side == 1 : side == 0 || side > 1;
    }

    @Override
    protected void readTanksFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tank")) {
            this.getFluidTank(0).readFromNBT(nbt.func_74775_l("Tank"));
        } else {
            super.readTanksFromNBT(nbt);
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_FruitPress(NBTTagCompound nbt) {
        if (nbt.func_74762_e("FruitPress_version") > 0) {
            this.fruitPress.readFromNBT(nbt, "fruit_press");
        } else {
            this.fruitPress.readFromNBT(nbt);
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_FruitPress(NBTTagCompound nbt) {
        this.fruitPress.writeToNBT(nbt, "fruit_press");
        nbt.func_74768_a("FruitPress_version", 2);
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        switch (id) {
            case 0: {
                this.fruitPress.setTime(v);
                break;
            }
            case 1: {
                this.fruitPress.setTimeMax(v);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.fruitPress.getTime());
        iCrafting.func_71112_a(container, 1, this.fruitPress.getTimeMax());
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    protected int doFill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainFluidTank(0, maxDrain, doDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection from, FluidStack stack, boolean doDrain) {
        if (stack == null || !stack.isFluidEqual(this.getFluidStack(0))) {
            return null;
        }
        return this.doDrain(from, stack.amount, doDrain);
    }

    public static class FruitPressDataID {
        public static final int TIME = 0;
        public static final int TIME_MAX = 1;

        private FruitPressDataID() {
        }
    }
}

