/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeEntry;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.event.EventWaterBag;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.common.item.GrcItemBase;
import growthcraft.core.lib.GrcCoreState;
import growthcraft.core.util.UnitFormatter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;

@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore")
public class ItemWaterBag
extends GrcItemBase
implements IFluidContainerItem,
IEdible {
    protected int capacity;
    protected int dosage;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public ItemWaterBag() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("grc.waterBag");
        this.func_111206_d("grccellar:water_bag");
        this.func_77637_a(GrowthCraftCellar.tab);
        this.field_77777_bU = 1;
        this.capacity = GrowthCraftCellar.getConfig().waterBagCapacity;
        this.dosage = GrowthCraftCellar.getConfig().waterBagDosage;
    }

    public NBTTagCompound getFluidTagFromStack(ItemStack stack) {
        if (stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("Fluid")) {
            return stack.field_77990_d.func_74775_l("Fluid");
        }
        return null;
    }

    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tag = this.getFluidTagFromStack(container);
        return tag != null ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[17];
        this.icons[0] = reg.func_94245_a(this.func_111208_A() + "/white");
        this.icons[1] = reg.func_94245_a(this.func_111208_A() + "/orange");
        this.icons[2] = reg.func_94245_a(this.func_111208_A() + "/magenta");
        this.icons[3] = reg.func_94245_a(this.func_111208_A() + "/light_blue");
        this.icons[4] = reg.func_94245_a(this.func_111208_A() + "/yellow");
        this.icons[5] = reg.func_94245_a(this.func_111208_A() + "/lime");
        this.icons[6] = reg.func_94245_a(this.func_111208_A() + "/pink");
        this.icons[7] = reg.func_94245_a(this.func_111208_A() + "/gray");
        this.icons[8] = reg.func_94245_a(this.func_111208_A() + "/light_gray");
        this.icons[9] = reg.func_94245_a(this.func_111208_A() + "/cyan");
        this.icons[10] = reg.func_94245_a(this.func_111208_A() + "/purple");
        this.icons[11] = reg.func_94245_a(this.func_111208_A() + "/blue");
        this.icons[12] = reg.func_94245_a(this.func_111208_A() + "/brown");
        this.icons[13] = reg.func_94245_a(this.func_111208_A() + "/green");
        this.icons[14] = reg.func_94245_a(this.func_111208_A() + "/red");
        this.icons[15] = reg.func_94245_a(this.func_111208_A() + "/black");
        this.icons[16] = reg.func_94245_a(this.func_111208_A() + "/default");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 17; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public int getFluidAmount(ItemStack container) {
        FluidStack stack = this.getFluid(container);
        if (FluidTest.isValid(stack)) {
            return stack.amount;
        }
        return 0;
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public int cappedFill(ItemStack container, FluidStack resource, boolean doFill, int fillCap) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == null) {
            return 0;
        }
        if (resource.getFluid().getTemperature() > 373) {
            return 0;
        }
        int amount = Math.min(resource.amount, fillCap);
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
                return Math.min(this.capacity, amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("Fluid")) {
            FluidStack res = resource.copy();
            res.amount = amount;
            NBTTagCompound fluidTag = res.writeToNBT(new NBTTagCompound());
            if (this.capacity < amount) {
                fluidTag.func_74768_a("Amount", this.capacity);
                container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
            return amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (amount < filled) {
            stack.amount += amount;
            filled = amount;
        } else {
            stack.amount = this.capacity;
        }
        container.field_77990_d.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        return this.cappedFill(container, resource, doFill, this.dosage);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int expectedDrain = Math.min(maxDrain, this.dosage);
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, expectedDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.field_77990_d.func_82580_o("Fluid");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", currentAmount - stack.amount);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.drink;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public boolean hasEnoughToDrink(ItemStack stack) {
        FluidStack drained = this.drain(stack, this.dosage, false);
        return drained != null && drained.amount >= this.dosage;
    }

    public BoozeEntry getBoozeEntry(ItemStack stack) {
        FluidStack fluidstack = this.getFluid(stack);
        if (fluidstack != null) {
            return CellarRegistry.instance().booze().getBoozeEntry(fluidstack.getFluid());
        }
        return null;
    }

    public int getHealAmount(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getHealAmount();
        }
        return 0;
    }

    public float getSaturation(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getSaturation();
        }
        return 0.0f;
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack stack) {
        return new FoodValues(this.getHealAmount(stack), this.getSaturation(stack));
    }

    protected void applyEffects(ItemStack stack, World world, EntityPlayer player) {
        FluidStack fluidstack = this.getFluid(stack);
        boolean cancelled = GrowthCraftCellar.CELLAR_BUS.post((Event)new EventWaterBag.PreApplyEffects(stack, world, player));
        if (!cancelled) {
            if (fluidstack != null) {
                BoozeUtils.addEffects(fluidstack.getFluid(), stack, world, player);
                player.func_71024_bL().func_75122_a(this.getHealAmount(stack), this.getSaturation(stack));
            }
            GrowthCraftCellar.CELLAR_BUS.post((Event)new EventWaterBag.PostApplyEffects(stack, world, player));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        boolean cancelled;
        if (this.hasEnoughToDrink(stack) && !(cancelled = GrowthCraftCellar.CELLAR_BUS.post((Event)new EventWaterBag.PreDrink(stack, world, player)))) {
            world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!world.field_72995_K) {
                this.applyEffects(stack, world, player);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.drain(stack, this.dosage, true);
                }
            }
            GrowthCraftCellar.CELLAR_BUS.post((Event)new EventWaterBag.PostDrink(stack, world, player));
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack _stack, EntityPlayer _p, World _w, int _x, int _y, int _z, int _d, float _fx, float _fy, float _fz) {
        return false;
    }

    private boolean tryFillByBlock(ItemStack stack, World world, EntityPlayer player) {
        int amount;
        FluidStack fs;
        Block block;
        int k;
        int j;
        int i;
        MovingObjectPosition pos = this.func_77621_a(world, player, true);
        if (pos != null && pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_72962_a(player, i = pos.field_72311_b, j = pos.field_72312_c, k = pos.field_72309_d) && player.func_82247_a(i, j, k, pos.field_72310_e, stack) && (block = world.func_147439_a(i, j, k)) != null && (fs = FluidUtils.drainFluidBlock(world, i, j, k, false)) != null && (amount = this.cappedFill(stack, fs, true, this.capacity)) > 0) {
            FluidUtils.drainFluidBlock(world, i, j, k, true);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.tryFillByBlock(stack, world, player)) {
            return stack;
        }
        if (this.hasEnoughToDrink(stack)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack stack) {
        String basename = super.func_77653_i(stack);
        String fluidName = UnitFormatter.fluidName(this.getFluid(stack));
        if (fluidName != null) {
            return GrcI18n.translate("grc.cellar.format.waterBag.name", basename, fluidName);
        }
        return basename;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        FluidStack fluidstack = this.getFluid(stack);
        if (fluidstack != null) {
            if (GrcCoreState.showDetailedInformation()) {
                String fluidname = UnitFormatter.fluidNameForContainer(fluidstack);
                list.add(GrcI18n.translate("grc.cellar.format.fluid_container.contents", fluidname, fluidstack.amount, this.getCapacity(stack)));
                Fluid booze = fluidstack.getFluid();
                BoozeUtils.addEffectInformation(booze, stack, player, list, bool);
            } else {
                list.add(EnumChatFormatting.GRAY + GrcI18n.translate("grc.tooltip.detailed_information", EnumChatFormatting.WHITE + "SHIFT" + EnumChatFormatting.GRAY));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return FluidTest.isValid(this.getFluid(stack));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack);
    }
}

