/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.world;

import cpw.mods.fml.common.IWorldGenerator;
import growthcraft.api.core.util.BiomeUtils;
import growthcraft.bamboo.GrowthCraftBamboo;
import growthcraft.bamboo.common.world.WorldGenBamboo;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGeneratorBamboo
implements IWorldGenerator {
    private final int rarity;

    public WorldGeneratorBamboo() {
        this.rarity = GrowthCraftBamboo.getConfig().bambooWorldGenRarity;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX, chunkZ);
        }
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (!world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat")) {
            String biomeId;
            int i = chunkX * 16 + random.nextInt(16) + 8;
            int j = random.nextInt(128);
            int k = chunkZ * 16 + random.nextInt(16) + 8;
            BiomeGenBase biome = world.func_72807_a(i, k);
            if (GrowthCraftBamboo.getConfig().useBiomeDict ? !BiomeUtils.testBiomeTypeTagsTable(biome, GrowthCraftBamboo.getConfig().bambooBiomesTypeList) : !BiomeUtils.testBiomeIdTags(biomeId = "" + biome.field_76756_M, GrowthCraftBamboo.getConfig().bambooBiomesIdList)) {
                return;
            }
            if (random.nextInt(this.rarity) == 0) {
                new WorldGenBamboo(true).generateClumps(world, random, i, j, k);
            }
        }
    }
}

