/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.fishtrap.user;

import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.fishtrap.BaitRegistry;
import growthcraft.api.fishtrap.FishTrapRegistry;
import growthcraft.api.fishtrap.user.UserBaitEntries;
import growthcraft.api.fishtrap.user.UserBaitEntry;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;

public class UserBaitConfig
extends AbstractUserJSONConfig {
    private final UserBaitEntries defaultEntries = new UserBaitEntries();
    private UserBaitEntries entries;

    public void addDefault(UserBaitEntry entry) {
        this.defaultEntries.data.add(entry);
    }

    public void addDefault(ItemStack stack, float base, float mul) {
        this.addDefault(new UserBaitEntry(stack, base, mul));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserBaitEntries)this.gson.fromJson((Reader)buff, UserBaitEntries.class);
    }

    private void addBaitEntry(UserBaitEntry entry) {
        if (entry == null) {
            this.logger.error("Invalid Entry", new Object[0]);
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            this.logger.error("Invalid item for entry {%s}", entry);
            return;
        }
        BaitRegistry.BaitHandle handle = new BaitRegistry.BaitHandle(entry.base_rate, entry.multiplier);
        for (IMultiItemStacks item : entry.item.getMultiItemStacks()) {
            FishTrapRegistry.instance().addBait(item, handle);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user bait entries.", this.entries.data.size());
                for (UserBaitEntry entry : this.entries.data) {
                    this.addBaitEntry(entry);
                }
            } else {
                this.logger.error("Config contains invalid data.", new Object[0]);
            }
        }
    }
}

