/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.module;

import growthcraft.api.core.freeze.FrozenObjectError;
import growthcraft.api.core.freeze.IFreezable;
import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.module.IModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class ModuleContainer
implements IModule,
IFreezable,
ILoggable,
Iterable<IModule> {
    protected List<IModule> subModules = new ArrayList<IModule>();
    protected ILogger logger = NullLogger.INSTANCE;
    private boolean frozen;

    @Override
    public Iterator<IModule> iterator() {
        return this.subModules.iterator();
    }

    public int size() {
        return this.subModules.size();
    }

    @Override
    public void freeze() {
        this.frozen = true;
        this.logger.debug("ModuleContainer %s has froze, it will error the next time a Module is added.", this);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    public void touch() {
        if (this.isFrozen()) {
            throw FrozenObjectError.newFor(this);
        }
    }

    public void add(@Nonnull IModule module) {
        this.touch();
        this.subModules.add(module);
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.touch();
        this.logger = l;
        for (IModule module : this.subModules) {
            if (!(module instanceof ILoggable)) continue;
            ((ILoggable)((Object)module)).setLogger(l);
        }
    }

    @Override
    public void preInit() {
        for (IModule module : this.subModules) {
            module.preInit();
        }
    }

    @Override
    public void register() {
        for (IModule module : this.subModules) {
            module.register();
        }
    }

    @Override
    public void init() {
        for (IModule module : this.subModules) {
            module.init();
        }
    }

    @Override
    public void postInit() {
        for (IModule module : this.subModules) {
            module.postInit();
        }
    }
}

