/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item.recipes;

import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.MultiItemStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.MultiStacksUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessMultiRecipe
implements IRecipe {
    private ItemStack output;
    private ArrayList<IMultiItemStacks> input = new ArrayList();
    private ArrayList<IMultiFluidStacks> fluids = new ArrayList();

    public ShapelessMultiRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessMultiRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessMultiRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(new MultiItemStacks(((ItemStack)in).func_77946_l()));
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new MultiItemStacks(new ItemStack((Item)in)));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new MultiItemStacks(new ItemStack((Block)in)));
                continue;
            }
            if (in instanceof String) {
                this.input.add(new OreItemStacks((String)in));
                continue;
            }
            if (in instanceof IMultiItemStacks) {
                this.input.add((IMultiItemStacks)in);
                continue;
            }
            if (in instanceof FluidStack) {
                this.fluids.add(MultiStacksUtil.toMultiFluidStacks(in));
                continue;
            }
            if (in instanceof IMultiFluidStacks) {
                this.fluids.add((IMultiFluidStacks)in);
                continue;
            }
            String ret = "Invalid shapeless multi recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        HashMap<IMultiFluidStacks, Integer> aggregateFluids = new HashMap<IMultiFluidStacks, Integer>();
        for (IMultiFluidStacks fluid : this.fluids) {
            aggregateFluids.put(fluid, fluid.getAmount());
        }
        ArrayList<IMultiItemStacks> required = new ArrayList<IMultiItemStacks>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<IMultiItemStacks> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                IMultiItemStacks next = req.next();
                Iterator<ItemStack> itr = next.getItemStacks().iterator();
                while (itr.hasNext() && !match) {
                    match = OreDictionary.itemMatches((ItemStack)itr.next(), (ItemStack)slot, (boolean)false);
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            boolean fluidConsumed = false;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)slot)) {
                FluidStack containerFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)slot).copy();
                for (IMultiFluidStacks fluidStacks : this.fluids) {
                    int aggregateAmount;
                    int n = aggregateAmount = aggregateFluids.containsKey(fluidStacks) ? (Integer)aggregateFluids.get(fluidStacks) : 0;
                    if (!fluidStacks.containsFluidStack(containerFluid) || aggregateAmount <= 0) continue;
                    int leftover = Math.max(0, aggregateAmount - containerFluid.amount);
                    if (leftover <= 1) {
                        aggregateFluids.remove(fluidStacks);
                    } else {
                        aggregateFluids.put(fluidStacks, leftover);
                    }
                    fluidConsumed = true;
                }
            }
            if (fluidConsumed) continue;
            return false;
        }
        return required.isEmpty() && aggregateFluids.isEmpty();
    }

    public ArrayList<IMultiItemStacks> getInput() {
        return this.input;
    }

    public List<IMultiFluidStacks> getFluids() {
        return this.fluids;
    }
}

