/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids;

import growthcraft.api.core.common.DuplicateRegistrationError;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.fluids.IFluidTagsRegistry;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class FluidTagsRegistry
implements IFluidTagsRegistry {
    private ILogger logger = NullLogger.INSTANCE;
    private Map<String, FluidTag> nameToTag = new HashMap<String, FluidTag>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void registerTag(@Nonnull FluidTag tag) {
        if (this.nameToTag.containsKey(tag.getName())) {
            throw DuplicateRegistrationError.newFor(tag);
        }
        this.nameToTag.put(tag.getName(), tag);
    }

    @Override
    public FluidTag createTag(@Nonnull String name) {
        FluidTag tag = new FluidTag(name);
        this.registerTag(tag);
        return tag;
    }

    @Override
    public Collection<String> getNames() {
        return this.nameToTag.keySet();
    }

    @Override
    public Collection<FluidTag> getTags() {
        return this.nameToTag.values();
    }

    @Override
    public FluidTag findTag(@Nonnull String name) {
        return this.nameToTag.get(name);
    }

    @Override
    public List<FluidTag> expandTagNames(@Nonnull List<String> tagNames) {
        ArrayList<FluidTag> tags = new ArrayList<FluidTag>();
        for (String name : tagNames) {
            tags.add(this.findTag(name));
        }
        return tags;
    }
}

