/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core;

import growthcraft.api.core.EffectRegistry;
import growthcraft.api.core.IEffectRegistry;
import growthcraft.api.core.IPotionEffectFactoryRegistry;
import growthcraft.api.core.PotionEffectFactoryRegistry;
import growthcraft.api.core.fluids.FluidDictionary;
import growthcraft.api.core.fluids.FluidTagsRegistry;
import growthcraft.api.core.fluids.IFluidDictionary;
import growthcraft.api.core.fluids.IFluidTagsRegistry;
import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.vines.IVineDropRegistry;
import growthcraft.api.core.vines.VineDropRegistry;
import javax.annotation.Nonnull;

public class CoreRegistry
implements ILoggable {
    private static final CoreRegistry instance = new CoreRegistry();
    protected ILogger logger = NullLogger.INSTANCE;
    private final IFluidDictionary fluidDictionary = new FluidDictionary();
    private final IFluidTagsRegistry fluidTagsRegistry = new FluidTagsRegistry();
    private final IEffectRegistry effectRegistry = new EffectRegistry().initialize();
    private final IPotionEffectFactoryRegistry potionEffectFactoryRegistry = new PotionEffectFactoryRegistry();
    private final IVineDropRegistry vineDropRegistry = new VineDropRegistry();

    public static final CoreRegistry instance() {
        return instance;
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
        this.fluidTagsRegistry.setLogger(this.logger);
        this.fluidDictionary.setLogger(this.logger);
        this.effectRegistry.setLogger(this.logger);
        this.potionEffectFactoryRegistry.setLogger(this.logger);
        this.vineDropRegistry.setLogger(this.logger);
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public IEffectRegistry getEffectsRegistry() {
        return this.effectRegistry;
    }

    public IPotionEffectFactoryRegistry getPotionEffectFactoryRegistry() {
        return this.potionEffectFactoryRegistry;
    }

    public IFluidTagsRegistry fluidTags() {
        return this.fluidTagsRegistry;
    }

    public IFluidDictionary fluidDictionary() {
        return this.fluidDictionary;
    }

    public IVineDropRegistry vineDrops() {
        return this.vineDropRegistry;
    }
}

