/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar;

import growthcraft.api.cellar.ICellarRegistry;
import growthcraft.api.cellar.booze.BoozeRegistry;
import growthcraft.api.cellar.booze.IBoozeRegistry;
import growthcraft.api.cellar.brewing.BrewingRegistry;
import growthcraft.api.cellar.brewing.IBrewingRegistry;
import growthcraft.api.cellar.culturing.CulturingRegistry;
import growthcraft.api.cellar.culturing.ICulturingRegistry;
import growthcraft.api.cellar.distilling.DistilleryRegistry;
import growthcraft.api.cellar.distilling.IDistilleryRegistry;
import growthcraft.api.cellar.fermenting.FermentingRegistry;
import growthcraft.api.cellar.fermenting.IFermentingRegistry;
import growthcraft.api.cellar.heatsource.HeatSourceRegistry;
import growthcraft.api.cellar.heatsource.IHeatSourceRegistry;
import growthcraft.api.cellar.init.CellarEffects;
import growthcraft.api.cellar.pressing.IPressingRegistry;
import growthcraft.api.cellar.pressing.PressingRegistry;
import growthcraft.api.cellar.yeast.IYeastRegistry;
import growthcraft.api.cellar.yeast.YeastRegistry;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import javax.annotation.Nonnull;

public class CellarRegistry
implements ICellarRegistry {
    private static final ICellarRegistry INSTANCE = new CellarRegistry().initialize();
    private final IBoozeRegistry boozeRegistry = new BoozeRegistry();
    private final IBrewingRegistry brewingRegistry = new BrewingRegistry();
    private final ICulturingRegistry culturingRegistry = new CulturingRegistry();
    private final IDistilleryRegistry distilleryRegistry = new DistilleryRegistry();
    private final IFermentingRegistry fermentingRegistry = new FermentingRegistry();
    private final IHeatSourceRegistry heatSourceRegistry = new HeatSourceRegistry();
    private final IPressingRegistry pressingRegistry = new PressingRegistry();
    private final IYeastRegistry yeastRegistry = new YeastRegistry();
    private ILogger logger = NullLogger.INSTANCE;

    public static final ICellarRegistry instance() {
        return INSTANCE;
    }

    private CellarRegistry initialize() {
        CellarEffects.init();
        return this;
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
        this.boozeRegistry.setLogger(this.logger);
        this.brewingRegistry.setLogger(this.logger);
        this.culturingRegistry.setLogger(this.logger);
        this.distilleryRegistry.setLogger(this.logger);
        this.fermentingRegistry.setLogger(this.logger);
        this.heatSourceRegistry.setLogger(this.logger);
        this.pressingRegistry.setLogger(this.logger);
        this.yeastRegistry.setLogger(this.logger);
    }

    @Override
    public IBoozeRegistry booze() {
        return this.boozeRegistry;
    }

    @Override
    public IBrewingRegistry brewing() {
        return this.brewingRegistry;
    }

    @Override
    public ICulturingRegistry culturing() {
        return this.culturingRegistry;
    }

    @Override
    public IPressingRegistry pressing() {
        return this.pressingRegistry;
    }

    @Override
    public IFermentingRegistry fermenting() {
        return this.fermentingRegistry;
    }

    @Override
    public IHeatSourceRegistry heatSource() {
        return this.heatSourceRegistry;
    }

    @Override
    public IDistilleryRegistry distilling() {
        return this.distilleryRegistry;
    }

    @Override
    public IYeastRegistry yeast() {
        return this.yeastRegistry;
    }
}

