/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.items;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.ConfigManager;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCell;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellBase;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCellBase;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import moze_intel.projecte.api.item.IItemEmc;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.input.Keyboard;

@Optional.Interface(iface="moze_intel.projecte.api.item.IItemEmc", modid="ProjectE")
public class ItemEMCCell
extends ItemEMCCellBase
implements IConfigurable,
IItemEmc {
    private static final String GROUP = "Storage Cells";
    private static final String EMC_TAG = "emc";
    private static final double[] CAPACITIES = new double[]{1000000.0, 4000000.0, 1.6E7, 6.4E7, 2.56E8, 1.024E9, 4.096E9, 1.6384E10};
    private static final double[] DRAIN = new double[]{0.1, 0.2, 0.4, 0.8, 1.6, 3.2, 6.4, 12.8};

    public ItemEMCCell() {
        super(8);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.values()[stack.func_77960_j() / 2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return TextureEnum.EMCCELL.getTexture(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean param4) {
        double curEMC = this.getStoredCellEMC(stack);
        String tooltip = StatCollector.func_74838_a((String)"tooltip.emc.name") + " ";
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            list.add(tooltip + String.format("%.2f", curEMC) + " / " + String.format("%.2f", CAPACITIES[stack.func_77960_j()]));
        } else {
            list.add(tooltip + CommonUtils.formatEMC(curEMC) + " / " + CommonUtils.formatEMC(CAPACITIES[stack.func_77960_j()]));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isEmpty(stack) && player != null && player.func_70093_af() && player.field_71071_by.func_70441_a(ItemEnum.MISCITEM.getDamagedStack(0))) {
            return ItemEnum.CELLCOMPONENT.getDamagedStack(stack.func_77960_j());
        }
        return stack;
    }

    @Override
    public void loadConfig(Configuration config) {
        for (int i = 0; i < this.itemCount; ++i) {
            try {
                ItemEMCCell.CAPACITIES[i] = Double.valueOf(config.get(GROUP, "Tier" + i + "_Capacity", String.format("%.0f", CAPACITIES[i])).getString());
            }
            catch (NumberFormatException e) {
                EquivalentEnergistics.logger.warn("Storage Cell Tier" + i + "_Capacity configured for invalid value! Default will be used!");
            }
            ItemEMCCell.DRAIN[i] = config.get(GROUP, "Tier_" + i + "_PowerDrain", DRAIN[i]).getDouble(DRAIN[i]);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IMEInventoryHandler getCellInventory(ItemStack stack, ISaveProvider host, StorageChannel channel) {
        if (channel == StorageChannel.ITEMS && this.isCell(stack)) {
            return new HandlerEMCCell(stack, host, CAPACITIES[stack.func_77960_j()]);
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getStatusForCell(ItemStack stack, IMEInventory handler) {
        return handler instanceof HandlerEMCCellBase ? ((HandlerEMCCellBase)handler).getCellStatus() : 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public double cellIdleDrain(ItemStack stack, IMEInventory handler) {
        return DRAIN[stack.func_77960_j()];
    }

    public double getStoredCellEMC(ItemStack stack) {
        if (!this.isCell(stack) || !this.hasEMCTag(stack)) {
            return 0.0;
        }
        return Math.max(stack.func_77978_p().func_74769_h(EMC_TAG), 0.0);
    }

    public double addEmc(ItemStack stack, double toAdd) {
        if (ConfigManager.useEE3) {
            return 0.0;
        }
        double currentEMC = this.getStoredCellEMC(stack);
        double amountToAdd = Math.min(toAdd, CAPACITIES[stack.func_77960_j()] - currentEMC);
        if (amountToAdd > 0.0) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74780_a(EMC_TAG, currentEMC + amountToAdd);
        }
        return amountToAdd;
    }

    public double extractEmc(ItemStack stack, double toRemove) {
        return ConfigManager.useEE3 ? 0.0 : this.extractCellEMC(stack, toRemove);
    }

    public double getStoredEmc(ItemStack stack) {
        return ConfigManager.useEE3 ? 0.0 : this.getStoredCellEMC(stack);
    }

    public double getMaximumEmc(ItemStack stack) {
        return ConfigManager.useEE3 ? 0.0 : CAPACITIES[stack.func_77960_j()];
    }

    public double extractCellEMC(ItemStack stack, double emc) {
        double currentEMC = this.getStoredCellEMC(stack);
        double toRemove = Math.min(emc, currentEMC);
        if (this.hasEMCTag(stack)) {
            stack.func_77978_p().func_74780_a(EMC_TAG, currentEMC - toRemove);
            if (this.isEmpty(stack)) {
                this.removeEMCTag(stack);
            }
        }
        return toRemove;
    }

    private void removeEMCTag(ItemStack stack) {
        stack.func_77978_p().func_82580_o(EMC_TAG);
        if (stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    private boolean hasEMCTag(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(EMC_TAG);
    }

    private boolean isEmpty(ItemStack stack) {
        return this.getStoredCellEMC(stack) == 0.0;
    }
}

