/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ee3;

import com.mojang.authlib.GameProfile;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterBase;
import com.mordenkainen.equivalentenergistics.integration.IEMCHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.EMCCraftingGrid;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCell;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import com.pahimar.ee3.api.event.EnergyValueEvent;
import com.pahimar.ee3.api.event.PlayerKnowledgeEvent;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.knowledge.PlayerKnowledgeRegistryProxy;
import com.pahimar.ee3.util.ItemStackUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class EquivExchange3
implements IEMCHandler {
    private static Item tomeItem;

    @Override
    public boolean hasEMC(ItemStack itemStack) {
        return EnergyValueRegistryProxy.hasEnergyValue((Object)itemStack);
    }

    @Override
    public double getEnergyValue(ItemStack itemStack) {
        EnergyValue val = EnergyValueRegistryProxy.getEnergyValue((Object)itemStack);
        return val == null ? 0.0 : (double)val.getValue();
    }

    @Override
    public double getCrystalEMC(int tier) {
        return ItemEMCCrystal.CRYSTAL_VALUES[tier];
    }

    @Override
    public List<ItemStack> getTransmutations(TileEMCCrafterBase tile) {
        ArrayList<ItemStack> transmutations = new ArrayList<ItemStack>(PlayerKnowledgeRegistryProxy.getKnownItemStacks((String)ItemStackUtils.getOwnerName((ItemStack)tile.getCurrentTome())));
        Iterator iter = transmutations.iterator();
        while (iter.hasNext()) {
            ItemStack currentItem = (ItemStack)iter.next();
            if (currentItem != null && !ItemEnum.isCrystal(currentItem)) continue;
            iter.remove();
        }
        return transmutations;
    }

    @Override
    public boolean isValidTome(ItemStack itemStack) {
        if (tomeItem == null) {
            tomeItem = GameRegistry.findItem((String)"EE3", (String)"alchenomicon");
        }
        return itemStack != null && itemStack.func_77973_b() == tomeItem && ItemStackUtils.getOwnerUUID((ItemStack)itemStack) != null;
    }

    @Override
    public void setCrystalEMC() {
    }

    @Override
    public UUID getTomeUUID(ItemStack currentTome) {
        return ItemStackUtils.getOwnerUUID((ItemStack)currentTome);
    }

    @Override
    public String getTomeOwner(ItemStack currentTome) {
        return ItemStackUtils.getOwnerName((ItemStack)currentTome);
    }

    @Override
    public double getSingleEnergyValue(ItemStack stack) {
        ItemStack singleStack = stack.func_77946_l();
        singleStack.field_77994_a = 1;
        return this.getEnergyValue(singleStack);
    }

    @SubscribeEvent
    public void onPlayerKnowledgeChange(PlayerKnowledgeEvent event) {
        EMCCraftingGrid.knowledgeEvent(event.playerUUID);
    }

    @SubscribeEvent
    public void onEnergyValueChange(EnergyValueEvent event) {
        EMCCraftingGrid.energyEvent();
    }

    @Override
    public boolean isEMCStorage(ItemStack stack) {
        return ItemEnum.EMCCELL.isSameItem(stack);
    }

    @Override
    public double getStoredEMC(ItemStack stack) {
        return ItemEnum.EMCCELL.isSameItem(stack) ? ((ItemEMCCell)ItemEnum.EMCCELL.getItem()).getStoredCellEMC(stack) : 0.0;
    }

    @Override
    public double extractEMC(ItemStack stack, double toStore) {
        return ItemEnum.EMCCELL.isSameItem(stack) ? ((ItemEMCCell)ItemEnum.EMCCELL.getItem()).extractCellEMC(stack, toStore) : 0.0;
    }

    public static void postPlayerLearn(String player) {
        GameProfile profile;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player != null && (profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(player)) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeEvent.PlayerLearnKnowledgeEvent(profile.getId(), null));
        }
    }

    public static void postPlayerForget(String player) {
        GameProfile profile;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player != null && (profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(player)) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeEvent.PlayerForgetKnowledgeEvent(profile.getId(), null));
        }
    }
}

