/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.core.proxy;

import com.mordenkainen.equivalentenergistics.blocks.BlockEnum;
import com.mordenkainen.equivalentenergistics.blocks.base.block.LayeredBlockRenderer;
import com.mordenkainen.equivalentenergistics.blocks.crafter.render.BlockEMCCrafterRenderer;
import com.mordenkainen.equivalentenergistics.blocks.crafter.render.TileEMCCrafterRenderer;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterBase;
import com.mordenkainen.equivalentenergistics.core.exceptions.ClientUnmetDependencyException;
import com.mordenkainen.equivalentenergistics.core.proxy.CommonProxy;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void initRenderers() {
        if (BlockEnum.EMCCRAFTER.isEnabled()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEMCCrafterBase.class, (TileEntitySpecialRenderer)new TileEMCCrafterRenderer());
            this.crafterRenderer = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockEMCCrafterRenderer());
            this.layeredRenderer = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new LayeredBlockRenderer());
        }
    }

    @Override
    public void unmetDependency() {
        throw new ClientUnmetDependencyException();
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.map;
        TextureEnum.registerTextures(map);
    }
}

