/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.blocks.base.block.BlockMultiContainerBase;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafter;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterAdv;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterBase;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterExt;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterUlt;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class BlockEMCCrafter
extends BlockMultiContainerBase
implements IConfigurable {
    private static final String GROUP = "Crafter";
    public static double idlePower;
    public static double powerPerEMC;
    public static double craftingTime;

    public BlockEMCCrafter() {
        super(Material.field_151576_e, 4);
        this.func_149711_c(1.5f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149713_g(1);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEMCCrafter();
            }
            case 1: {
                return new TileEMCCrafterAdv();
            }
            case 2: {
                return new TileEMCCrafterExt();
            }
        }
        return new TileEMCCrafterUlt();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return EquivalentEnergistics.proxy.crafterRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return TextureEnum.EMCCONDENSER.getTexture();
    }

    public final boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEMCCrafterBase tileCrafter = CommonUtils.getTE(TileEMCCrafterBase.class, (IBlockAccess)world, x, y, z);
        if (tileCrafter == null || !tileCrafter.canPlayerInteract(player)) {
            return false;
        }
        ItemStack existingTome = tileCrafter.getCurrentTome();
        if (Integration.emcHandler.isValidTome(player.func_70694_bm()) && existingTome == null) {
            tileCrafter.setCurrentTome(player.func_70694_bm().func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            }
            return true;
        }
        if (existingTome != null) {
            tileCrafter.setCurrentTome(null);
            if (!world.field_72995_K) {
                CommonUtils.spawnEntItem(world, x, y, z, existingTome);
            }
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig(Configuration config) {
        idlePower = config.get(GROUP, "IdlePowerDrain", 0.0).getDouble(0.0);
        powerPerEMC = config.get(GROUP, "PowerDrainPerEMC", 0.01).getDouble(0.01);
        craftingTime = config.get(GROUP, "TicksPerCrafting", 20).getInt(20);
    }
}

