/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.base.block;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.blocks.base.block.ILayeredBlock;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class LayeredBlockRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.field_147844_c) {
            int j = block.func_149741_i(metadata);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)1.0f);
        }
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            tessellator.func_78382_b();
            tessellator.func_78375_b((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
            this.renderFaceWithLayers(renderer, block, metadata, dir, 0.0, 0.0, 0.0, true);
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int color = block.func_149720_d(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float r3d = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float g3d = (r * 30.0f + g * 70.0f) / 100.0f;
            float b3d = (r * 30.0f + b * 70.0f) / 100.0f;
            r = r3d;
            g = g3d;
            b = b3d;
        }
        return Minecraft.func_71379_u() && block.func_149750_m() == 0 ? this.renderLayeredBlockWithAmbientOcclusion(renderer, block, meta, x, y, z, r, g, b) : this.renderLayeredBlockWithColorMultiplier(renderer, block, meta, x, y, z, r, g, b);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return EquivalentEnergistics.proxy.layeredRenderer;
    }

    private boolean renderLayeredBlockWithAmbientOcclusion(RenderBlocks renderer, Block block, int metadata, int x, int y, int z, float r, float g, float b) {
        boolean rendered = false;
        renderer.field_147863_w = true;
        int blockBrightness = block.func_149677_c(renderer.field_147845_a, x, y, z);
        Tessellator.field_78398_a.func_78380_c(983055);
        float[] faceBrightnesses = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
        boolean[] boundryTest = new boolean[]{renderer.field_147855_j <= 0.0, renderer.field_147857_k >= 1.0, renderer.field_147851_l <= 0.0, renderer.field_147853_m >= 1.0, renderer.field_147859_h <= 0.0, renderer.field_147861_i >= 1.0};
        int[][][] corners = new int[][][]{new int[][]{{-1, -1, -1}, {1, -1, -1}, {1, -1, 1}, {-1, -1, 1}}, new int[][]{{-1, 1, -1}, {1, 1, -1}, {1, 1, 1}, {-1, 1, 1}}, new int[][]{{-1, -1, -1}, {1, -1, -1}, {1, 1, -1}, {-1, 1, -1}}, new int[][]{{-1, -1, 1}, {1, -1, 1}, {1, -1, 1}, {-1, -1, 1}}, new int[][]{{-1, -1, -1}, {-1, 1, -1}, {-1, 1, 1}, {-1, -1, 1}}, new int[][]{{1, -1, -1}, {1, 1, -1}, {1, 1, 1}, {1, -1, 1}}};
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            if (!renderer.field_147837_f && !block.func_149646_a(renderer.field_147845_a, x + face.offsetX, y + face.offsetY, z + face.offsetZ, face.ordinal())) continue;
            int offset = 0;
            if (boundryTest[face.ordinal()]) {
                offset = 1;
            }
            int[] brightnesses = new int[8];
            float[] occlusionValues = new float[8];
            boolean[] transparencies = new boolean[4];
            ForgeDirection[] sides = EnumSet.complementOf(EnumSet.of(face, face.getOpposite(), ForgeDirection.UNKNOWN)).toArray(new ForgeDirection[0]);
            for (int i = 0; i < 4; ++i) {
                int x1 = x + sides[i].offsetX + face.offsetX * offset;
                int y1 = y + sides[i].offsetY + face.offsetY * offset;
                int z1 = z + sides[i].offsetZ + face.offsetZ * offset;
                brightnesses[i] = block.func_149677_c(renderer.field_147845_a, x1, y1, z1);
                occlusionValues[i] = renderer.field_147845_a.func_147439_a(x1, y1, z1).func_149685_I();
                transparencies[i] = renderer.field_147845_a.func_147439_a(x1, y1, z1).func_149751_l();
            }
            if (transparencies[0] || transparencies[2]) {
                brightnesses[4] = block.func_149677_c(renderer.field_147845_a, x + corners[face.ordinal()][0][0], y + corners[face.ordinal()][0][1], z + corners[face.ordinal()][0][2]);
                occlusionValues[4] = renderer.field_147845_a.func_147439_a(x + corners[face.ordinal()][0][0], y + corners[face.ordinal()][0][1], z + corners[face.ordinal()][0][2]).func_149685_I();
            } else {
                brightnesses[4] = (brightnesses[0] + brightnesses[2]) / 2;
                occlusionValues[4] = (occlusionValues[0] + occlusionValues[2]) / 2.0f;
            }
            if (transparencies[1] || transparencies[2]) {
                brightnesses[5] = block.func_149677_c(renderer.field_147845_a, x + corners[face.ordinal()][1][0], y + corners[face.ordinal()][1][1], z + corners[face.ordinal()][1][2]);
                occlusionValues[5] = renderer.field_147845_a.func_147439_a(x + corners[face.ordinal()][1][0], y + corners[face.ordinal()][1][1], z + corners[face.ordinal()][1][2]).func_149685_I();
            } else {
                brightnesses[5] = (brightnesses[1] + brightnesses[2]) / 2;
                occlusionValues[5] = (occlusionValues[1] + occlusionValues[2]) / 2.0f;
            }
            if (transparencies[1] || transparencies[3]) {
                brightnesses[6] = block.func_149677_c(renderer.field_147845_a, x + corners[face.ordinal()][2][0], y + corners[face.ordinal()][2][1], z + corners[face.ordinal()][2][2]);
                occlusionValues[6] = renderer.field_147845_a.func_147439_a(x + corners[face.ordinal()][2][0], y + corners[face.ordinal()][2][1], z + corners[face.ordinal()][2][2]).func_149685_I();
            } else {
                brightnesses[6] = (brightnesses[1] + brightnesses[3]) / 2;
                occlusionValues[6] = (occlusionValues[1] + occlusionValues[3]) / 2.0f;
            }
            if (transparencies[0] || transparencies[3]) {
                brightnesses[7] = block.func_149677_c(renderer.field_147845_a, x + corners[face.ordinal()][3][0], y + corners[face.ordinal()][3][1], z + corners[face.ordinal()][3][2]);
                occlusionValues[7] = renderer.field_147845_a.func_147439_a(x + corners[face.ordinal()][3][0], y + corners[face.ordinal()][3][1], z + corners[face.ordinal()][3][2]).func_149685_I();
            } else {
                brightnesses[7] = (brightnesses[0] + brightnesses[3]) / 2;
                occlusionValues[7] = (occlusionValues[0] + occlusionValues[3]) / 2.0f;
            }
            int faceBrightness = blockBrightness;
            if (boundryTest[face.ordinal()] || !renderer.field_147845_a.func_147439_a(x + face.offsetX, y + face.offsetY, z + face.offsetZ).func_149662_c()) {
                faceBrightness = block.func_149677_c(renderer.field_147845_a, x + face.offsetX, y + face.offsetY, z + face.offsetZ);
            }
            float faceocclusion = renderer.field_147845_a.func_147439_a(x + face.offsetX, y + face.offsetY, z + face.offsetZ).func_149685_I();
            float lightValueTL = (faceocclusion + occlusionValues[0] + occlusionValues[7] + occlusionValues[3]) / 4.0f;
            float lightValueBL = (faceocclusion + occlusionValues[0] + occlusionValues[4] + occlusionValues[2]) / 4.0f;
            float lightValueBR = (faceocclusion + occlusionValues[1] + occlusionValues[6] + occlusionValues[3]) / 4.0f;
            float lightValueTR = (faceocclusion + occlusionValues[1] + occlusionValues[5] + occlusionValues[2]) / 4.0f;
            renderer.field_147864_al = renderer.func_147778_a(brightnesses[0], brightnesses[7], brightnesses[3], faceBrightness);
            renderer.field_147874_am = renderer.func_147778_a(brightnesses[0], brightnesses[4], brightnesses[2], faceBrightness);
            renderer.field_147876_an = renderer.func_147778_a(brightnesses[1], brightnesses[6], brightnesses[3], faceBrightness);
            renderer.field_147870_ao = renderer.func_147778_a(brightnesses[1], brightnesses[5], brightnesses[2], faceBrightness);
            this.setRendererColors(renderer, r, g, b, faceBrightnesses[face.ordinal()], lightValueTL, lightValueBL, lightValueBR, lightValueTR, !renderer.func_147744_b());
            this.renderFaceWithLayers(renderer, block, metadata, face, x, y, z, false);
            rendered = true;
        }
        renderer.field_147863_w = false;
        return rendered;
    }

    private void setRendererColors(RenderBlocks renderer, float r, float g, float b, float sideMult, float multTopLeft, float multBotLeft, float multBotRight, float multTopRight, boolean flag) {
        if (flag) {
            renderer.field_147850_ar = renderer.field_147848_as = r * sideMult;
            renderer.field_147852_aq = renderer.field_147848_as;
            renderer.field_147872_ap = renderer.field_147848_as;
            renderer.field_147858_av = renderer.field_147856_aw = g * sideMult;
            renderer.field_147860_au = renderer.field_147856_aw;
            renderer.field_147846_at = renderer.field_147856_aw;
            renderer.field_147839_az = renderer.field_147833_aA = b * sideMult;
            renderer.field_147841_ay = renderer.field_147833_aA;
            renderer.field_147854_ax = renderer.field_147833_aA;
        } else {
            renderer.field_147850_ar = renderer.field_147848_as = sideMult;
            renderer.field_147852_aq = renderer.field_147848_as;
            renderer.field_147872_ap = renderer.field_147848_as;
            renderer.field_147858_av = renderer.field_147856_aw = sideMult;
            renderer.field_147860_au = renderer.field_147856_aw;
            renderer.field_147846_at = renderer.field_147856_aw;
            renderer.field_147839_az = renderer.field_147833_aA = sideMult;
            renderer.field_147841_ay = renderer.field_147833_aA;
            renderer.field_147854_ax = renderer.field_147833_aA;
        }
        renderer.field_147872_ap *= multTopLeft;
        renderer.field_147846_at *= multTopLeft;
        renderer.field_147854_ax *= multTopLeft;
        renderer.field_147852_aq *= multBotLeft;
        renderer.field_147860_au *= multBotLeft;
        renderer.field_147841_ay *= multBotLeft;
        renderer.field_147850_ar *= multBotRight;
        renderer.field_147858_av *= multBotRight;
        renderer.field_147839_az *= multBotRight;
        renderer.field_147848_as *= multTopRight;
        renderer.field_147856_aw *= multTopRight;
        renderer.field_147833_aA *= multTopRight;
    }

    private boolean renderLayeredBlockWithColorMultiplier(RenderBlocks renderer, Block block, int metadata, int x, int y, int z, float r, float g, float b) {
        renderer.field_147863_w = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean flag = false;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        boolean[] blockTests = new boolean[]{renderer.field_147855_j > 0.0, renderer.field_147857_k < 1.0, renderer.field_147851_l > 0.0, renderer.field_147853_m < 1.0, renderer.field_147859_h > 0.0, renderer.field_147861_i < 1.0};
        float[] brightnesses = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!renderer.field_147837_f && !block.func_149646_a(renderer.field_147845_a, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.ordinal())) continue;
            tessellator.func_78380_c(blockTests[dir.ordinal()] ? l : block.func_149677_c(renderer.field_147845_a, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
            float brightness = brightnesses[dir.ordinal()];
            tessellator.func_78386_a(brightness * r, brightness * g, brightness * b);
            this.renderFaceWithLayers(renderer, block, metadata, dir, x, y, z, false);
            flag = true;
        }
        return flag;
    }

    private void renderFaceWithLayers(RenderBlocks renderer, Block block, int metadata, ForgeDirection dir, double x, double y, double z, boolean inv) {
        ILayeredBlock layers = (ILayeredBlock)block;
        this.renderFaceByDir(renderer, block, dir, x, y, z, renderer.func_147787_a(block, dir.ordinal(), metadata));
        int numLayers = inv ? layers.numLayers(block, metadata) : layers.numLayers(renderer.field_147845_a, block, (int)x, (int)y, (int)z, metadata);
        for (int i = 1; i <= numLayers; ++i) {
            IIcon layer;
            IIcon iIcon = layer = inv ? layers.getLayer(block, dir.ordinal(), metadata, i) : layers.getLayer(renderer.field_147845_a, block, (int)x, (int)y, (int)z, dir.ordinal(), metadata, i);
            if (layer == null) continue;
            this.renderFaceByDir(renderer, block, dir, x + (double)(dir.offsetX * i) * 1.0E-5, y + (double)(dir.offsetY * i) * 1.0E-5, z + (double)(dir.offsetZ * i) * 1.0E-5, layer);
        }
    }

    private void renderFaceByDir(RenderBlocks renderer, Block block, ForgeDirection dir, double x, double y, double z, IIcon icon) {
        switch (dir) {
            case DOWN: {
                renderer.func_147768_a(block, x, y, z, icon);
                break;
            }
            case UP: {
                renderer.func_147806_b(block, x, y, z, icon);
                break;
            }
            case NORTH: {
                renderer.func_147761_c(block, x, y, z, icon);
                break;
            }
            case SOUTH: {
                renderer.func_147734_d(block, x, y, z, icon);
                break;
            }
            case WEST: {
                renderer.func_147798_e(block, x, y, z, icon);
                break;
            }
            case EAST: {
                renderer.func_147764_f(block, x, y, z, icon);
                break;
            }
        }
    }
}

