/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.schematic;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.schematic.Schematic;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicMap
extends Schematic
implements ISave {
    public static final String BLOCK_LIST_SAVE_NAME = "BlockList";
    public static final String BLOCK_REF_SAVE_NAME = "BlockRef";
    public static final String BLOCK_MAP_SAVE_NAME = "BlockMap";
    private static final LinkedHashMap<String, Block> BLOCK_SAVE_MAP = new LinkedHashMap();
    private static final LinkedHashMap<Block, String> BLOCK_SAVE_MAP_REV = new LinkedHashMap();
    public Pos schematicSize;
    public Pos schematicCenter;
    public LinkedHashMap<Pos, Pair<Block, Integer>> block_map = new LinkedHashMap();
    public boolean init = false;
    protected String name;

    public static void registerSaveBlock(String name, Block block) {
        BLOCK_SAVE_MAP.put(name, block);
        BLOCK_SAVE_MAP_REV.put(block, name);
    }

    public void init() {
        if (this.schematicSize != null) {
            this.init = true;
            this.schematicCenter = new Pos(this.schematicSize.x() / 2.0, 0.0, this.schematicSize.z() / 2.0);
        }
    }

    public void build(Location spot, boolean doWorldCheck) {
        if (this.block_map != null) {
            ArrayList<IWorldEdit> blocksToPlace = new ArrayList<IWorldEdit>();
            this.getBlocksToPlace(spot, blocksToPlace, doWorldCheck, doWorldCheck);
            for (IWorldEdit edit : blocksToPlace) {
                edit.place();
            }
        }
    }

    public void getBlocksToPlace(Location spot, List<IWorldEdit> blockMap, boolean checkWorld, boolean checkIfWorldIsLoaded) {
        if (this.block_map != null) {
            for (Map.Entry<Pos, Pair<Block, Integer>> entry : this.block_map.entrySet()) {
                Block block = (Block)entry.getValue().left();
                int meta = (Integer)entry.getValue().right();
                if (block != null && block == Blocks.field_150360_v) continue;
                if (meta > 15) {
                    meta = 15;
                } else if (meta < 0) {
                    meta = 0;
                }
                Pos setPos = (Pos)((Pos)spot.toPos().subtract(this.schematicCenter)).add(entry.getKey());
                if (checkWorld) {
                    if (checkIfWorldIsLoaded) {
                        Chunk chunk = spot.world.func_72938_d(setPos.xi(), setPos.zi());
                        if (!chunk.field_76636_d) continue;
                    }
                    Block checkID = setPos.getBlock((IBlockAccess)spot.world);
                    int checkMeta = setPos.getBlockMetadata((IBlockAccess)spot.world);
                    if (checkID == block && checkMeta == meta) continue;
                }
                blockMap.add(new BlockEdit(spot.world, setPos).set(block, meta));
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (!this.init) {
            this.init();
        }
        NBTTagCompound blockNBT = nbt.func_74775_l(BLOCK_LIST_SAVE_NAME);
        if (this.schematicSize != null) {
            nbt.func_74768_a("sizeX", (int)this.schematicSize.x());
            nbt.func_74768_a("sizeY", (int)this.schematicSize.y());
            nbt.func_74768_a("sizeZ", (int)this.schematicSize.z());
        }
        if (this.schematicCenter != null) {
            nbt.func_74768_a("centerX", (int)this.schematicCenter.x());
            nbt.func_74768_a("centerY", (int)this.schematicCenter.y());
            nbt.func_74768_a("centerZ", (int)this.schematicCenter.z());
        }
        int i = 0;
        for (Map.Entry<Pos, Pair<Block, Integer>> entry : this.block_map.entrySet()) {
            String output = "";
            Block block = (Block)entry.getValue().left();
            output = block != null && BLOCK_SAVE_MAP_REV.containsKey(block) ? output + BLOCK_SAVE_MAP_REV.get(block) : output + entry.getValue().left();
            output = output + ":" + entry.getValue().right();
            output = output + ":" + entry.getKey().x() + ":" + (int)entry.getKey().y() + ":" + (int)entry.getKey().z();
            blockNBT.func_74778_a("Block" + i, output);
            ++i;
        }
        blockNBT.func_74768_a("count", i);
        nbt.func_74782_a(BLOCK_LIST_SAVE_NAME, (NBTBase)blockNBT);
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.schematicSize = new Pos(nbt.func_74762_e("sizeX"), nbt.func_74762_e("sizeY"), nbt.func_74762_e("sizeZ"));
        this.schematicCenter = new Pos(nbt.func_74762_e("centerX"), nbt.func_74762_e("centerY"), nbt.func_74762_e("centerZ"));
        NBTTagCompound blockDataSave = nbt.func_74775_l(BLOCK_LIST_SAVE_NAME);
        for (int blockCount = 0; blockCount < blockDataSave.func_74762_e("count"); ++blockCount) {
            String blockString = blockDataSave.func_74779_i("Block" + blockCount);
            String[] blockData = blockString.split(":");
            Block block = null;
            int blockMeta = 0;
            Pos blockPostion = new Pos();
            if (blockData == null) continue;
            try {
                if (blockData.length > 0) {
                    block = BLOCK_SAVE_MAP.containsKey(blockData[0]) ? BLOCK_SAVE_MAP.get(blockData[0]) : Block.func_149729_e((int)Integer.parseInt(blockData[0]));
                }
                if (blockData.length > 1) {
                    blockMeta = Integer.parseInt(blockData[1]);
                }
                int x = 0;
                int y = 0;
                int z = 0;
                if (blockData.length > 2) {
                    x = Integer.parseInt(blockData[2]);
                }
                if (blockData.length > 3) {
                    y = Integer.parseInt(blockData[3]);
                }
                if (blockData.length > 4) {
                    z = Integer.parseInt(blockData[4]);
                }
                blockPostion = new Pos(x, y, z);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.block_map.put(blockPostion, (Pair<Block, Integer>)new Pair(block, (Object)blockMeta));
        }
        if (!this.init) {
            this.init();
        }
    }

    public void getFromResourceFolder(String fileName) {
        try {
            this.load(CompressedStreamTools.func_74796_a((InputStream)SchematicMap.class.getResource("/assets/artillects/schematics/" + fileName + ".dat").openStream()));
            this.name = fileName;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToBaseDirectory(String fileName) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.save(nbt);
            NBTUtility.saveData(new File(NBTUtility.getBaseDirectory(), "schematics"), fileName, nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SchematicMap loadWorldSelection(World world, IPos3D pos, IPos3D pos2) {
        Pos start = new Pos(pos.x() > pos2.x() ? pos2.x() : pos.x(), pos.y() > pos2.y() ? pos2.y() : pos.y(), pos.z() > pos2.z() ? pos2.z() : pos.z());
        SchematicMap sch = new SchematicMap();
        int deltaX = pos.x() < pos2.x() ? (int)(pos2.x() - pos.x() + 1.0) : (int)(pos.x() - pos2.x() + 1.0);
        int deltaY = pos.y() < pos2.y() ? (int)(pos2.y() - pos.y() + 1.0) : (int)(pos.y() - pos2.y() + 1.0);
        int deltaZ = pos.z() < pos2.z() ? (int)(pos2.z() - pos.z() + 1.0) : (int)(pos.z() - pos2.z() + 1.0);
        sch.schematicSize = new Pos(deltaX, deltaY, deltaZ);
        for (int x = 0; x < deltaX; ++x) {
            for (int y = 0; y < deltaY; ++y) {
                for (int z = 0; z < deltaZ; ++z) {
                    Block block = world.func_147439_a((int)start.x() + x, (int)start.y() + y, (int)start.z() + z);
                    int blockMeta = world.func_72805_g((int)start.x() + x, (int)start.y() + y, (int)start.z() + z);
                    sch.block_map.put(new Pos(x, y, z), (Pair<Block, Integer>)new Pair((Object)block, (Object)blockMeta));
                }
            }
        }
        return sch;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HashMap<Pos, Pair<Block, Integer>> getStructure(ForgeDirection dir, int size) {
        return this.block_map;
    }
}

