/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.item;

import com.builtbroken.jlib.data.Colors;
import com.builtbroken.mc.api.items.listeners.IItemActivationListener;
import com.builtbroken.mc.api.items.listeners.IItemEventListener;
import com.builtbroken.mc.api.items.listeners.IItemWithListeners;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.IJsonRenderStateProvider;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.packet.PacketPlayerItem;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.framework.item.ItemListenerIterator;
import com.builtbroken.mc.framework.item.ItemNode;
import com.builtbroken.mc.framework.item.ItemNodeSubType;
import com.builtbroken.mc.framework.json.IJsonGenMod;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBase
extends Item
implements IJsonRenderStateProvider,
IJsonGenObject,
IItemWithListeners,
IPacketReceiver {
    public final ItemNode node;
    public final HashMap<String, List<IItemEventListener>> listeners = new HashMap();
    protected boolean registered = false;
    public CreativeTabs[] creativeTabsToDisplayOn;

    public ItemBase(ItemNode node) {
        this.node = node;
        this.node.item = this;
    }

    public ItemBase(String id, String owner, String name) {
        this(new ItemNode(owner, id));
        this.node.setUnlocalizedName(name);
    }

    public String func_77667_c(ItemStack stack) {
        if (this.func_77614_k() && !this.node.subTypeHashMap.isEmpty()) {
            if (this.node.subTypeHashMap.containsKey(stack.func_77960_j())) {
                return "item." + this.field_77774_bZ + "." + this.node.subTypeHashMap.get((Object)Integer.valueOf((int)stack.func_77960_j())).unlocalizedName;
            }
            return "item." + this.field_77774_bZ + "." + stack.func_77960_j();
        }
        return "item." + this.field_77774_bZ;
    }

    public Item func_77655_b(String name) {
        this.field_77774_bZ = name;
        if (this.field_111218_cA == null) {
            this.func_111206_d(name);
        }
        return this;
    }

    @Override
    public List<IItemEventListener> getItemListeners(String key) {
        return this.listeners.get(key);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        if (Engine.runningAsDev) {
            list.add("Node: " + this.node.getClass().getSimpleName());
            list.add("RenderID: " + this.getRenderContentID(stack));
            list.add("RenderS: " + this.getRenderKey(stack));
            list.add("RenderE: " + this.getRenderKey(stack, (Entity)player, player.func_71052_bv()));
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            boolean first = true;
            if (ids != null && ids.length > 0) {
                for (int id : ids) {
                    if (first) {
                        first = false;
                        list.add("Ore: " + Colors.GREY.code + OreDictionary.getOreName((int)id));
                        continue;
                    }
                    list.add("     " + Colors.GREY.code + OreDictionary.getOreName((int)id));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List items) {
        String tabName;
        if (tab != null && (tabName = tab.func_78013_b()) != null) {
            this.collectSubTypes(items, tabName);
        }
    }

    public void collectSubTypes(List items, String tab) {
        if (this.func_77614_k() && !this.node.subTypeHashMap.values().isEmpty()) {
            for (ItemNodeSubType type : this.node.subTypeHashMap.values()) {
                this.getSubItems(type, tab, items);
            }
        } else if (tab == null || tab.equalsIgnoreCase(this.node.getTabToDisplayOn())) {
            items.add(new ItemStack((Item)this, 1, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void getSubItems(ItemNodeSubType type, String tab, List items) {
        if (tab == null || tab.equalsIgnoreCase(type.getTabToDisplayOn()) || type.getTabToDisplayOn() == null && tab.equalsIgnoreCase(this.node.getTabToDisplayOn())) {
            items.add(new ItemStack((Item)this, 1, type.index));
        }
    }

    /*
     * WARNING - void declaration
     */
    public CreativeTabs[] getCreativeTabs() {
        if (this.creativeTabsToDisplayOn == null) {
            ArrayList<String> tabNames = new ArrayList<String>();
            if (this.node.getTabToDisplayOn() != null) {
                tabNames.add(this.node.getTabToDisplayOn());
            }
            if (this.func_77614_k()) {
                for (ItemNodeSubType itemNodeSubType : this.node.subTypeHashMap.values()) {
                    String key;
                    if (itemNodeSubType.getTabToDisplayOn() == null || tabNames.contains(key = itemNodeSubType.getTabToDisplayOn())) continue;
                    tabNames.add(key);
                }
            }
            if (!tabNames.isEmpty()) {
                void var5_11;
                ArrayList<CreativeTabs> tabs = new ArrayList<CreativeTabs>();
                CreativeTabs[] creativeTabsArray = CreativeTabs.field_78032_a;
                int n = creativeTabsArray.length;
                boolean bl = false;
                while (var5_11 < n) {
                    String key;
                    CreativeTabs tab = creativeTabsArray[var5_11];
                    if (tab != this.func_77640_w() && tabNames.contains(key = tab.func_78013_b().toLowerCase())) {
                        tabs.add(tab);
                    }
                    ++var5_11;
                }
                this.creativeTabsToDisplayOn = new CreativeTabs[tabs.size() + 1];
                this.creativeTabsToDisplayOn[0] = this.func_77640_w();
                boolean bl2 = true;
                for (CreativeTabs creativeTabs : tabs) {
                    this.creativeTabsToDisplayOn[++var3_6] = creativeTabs;
                }
            } else {
                this.creativeTabsToDisplayOn = new CreativeTabs[]{this.func_77640_w()};
            }
        }
        return this.creativeTabsToDisplayOn;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.getIconFromState(ClientDataHandler.INSTANCE.getRenderData(this.getRenderContentID(meta)), meta, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        RenderData data = ClientDataHandler.INSTANCE.getRenderData(this.getRenderContentID(metadata));
        if (data != null) {
            return data.getItemRenderLayers(metadata);
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        return this.getIconFromState(ClientDataHandler.INSTANCE.getRenderData(this.getRenderContentID(meta)), meta, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        IIcon icon;
        IRenderState state;
        String renderKey;
        String contentID = this.getRenderContentID(stack);
        RenderData data = ClientDataHandler.INSTANCE.getRenderData(contentID);
        if (data != null && (renderKey = this.getRenderKey(stack, (Entity)player, useRemaining)) != null && (state = data.getState("item.inventory." + renderKey)) != null && (icon = state.getIcon(renderPass)) != null) {
            return icon;
        }
        return this.getIcon(stack, renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        String contentID = this.getRenderContentID(stack);
        RenderData data = ClientDataHandler.INSTANCE.getRenderData(contentID);
        if (data != null) {
            ArrayList<String> keys = new ArrayList<String>();
            String recommendedKey = this.getRenderKey(stack);
            if (recommendedKey != null && !recommendedKey.isEmpty()) {
                keys.add("item.inventory." + recommendedKey + "." + pass);
                keys.add("item.inventory." + recommendedKey);
                keys.add(recommendedKey);
            }
            keys.add("item.inventory." + pass);
            keys.add("item.inventory");
            for (String key : keys) {
                IIcon icon;
                IRenderState state = data.getState(key);
                if (state == null || (icon = state.getIcon(pass)) == null) continue;
                return icon;
            }
        }
        return this.func_77618_c(stack.func_77960_j(), pass);
    }

    public String getRenderKey(ItemStack stack) {
        if (this.func_77614_k() && this.node.subTypeHashMap.containsKey(stack.func_77960_j())) {
            return this.node.subTypeHashMap.get((Object)Integer.valueOf((int)stack.func_77960_j())).id;
        }
        return null;
    }

    public String getRenderKey(ItemStack stack, Entity entity, int useRemaining) {
        return null;
    }

    protected IIcon getIconFromState(RenderData data, int meta, int pass) {
        if (data != null) {
            for (String key : this.getPossibleRenderStateKeys(meta, pass)) {
                IIcon icon;
                IRenderState state = data.getState(key);
                if (state == null || (icon = state.getIcon(pass)) == null) continue;
                return icon;
            }
        }
        return this.getFallBackIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int meta = stack.func_77960_j();
        RenderData data = ClientDataHandler.INSTANCE.getRenderData(this.getRenderContentID(meta));
        if (data != null) {
            for (String key : this.getPossibleRenderStateKeys(meta, pass)) {
                int color;
                IRenderState state = data.getState(key);
                if (state == null || (color = state.getColorForTexture(pass)) == -1) continue;
                return color;
            }
        }
        return 0xFFFFFF;
    }

    public List<String> getPossibleRenderStateKeys(int meta, int pass) {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.node.hasSubTypes() && this.node.subTypeHashMap.containsKey(meta)) {
            keys.add("item.inventory." + this.node.subTypeHashMap.get((Object)Integer.valueOf((int)meta)).id + "." + pass);
            keys.add("item.inventory." + this.node.subTypeHashMap.get((Object)Integer.valueOf((int)meta)).id);
            keys.add(this.node.subTypeHashMap.get((Object)Integer.valueOf((int)meta)).id);
            keys.add(this.node.subTypeHashMap.get((Object)Integer.valueOf((int)meta)).id + "." + pass);
        }
        keys.add("item.inventory." + meta + "." + pass);
        keys.add("item.inventory." + meta);
        keys.add("item.inventory." + pass);
        keys.add("item.inventory");
        return keys;
    }

    protected IIcon getFallBackIcon() {
        return this.field_77791_bV != null ? this.field_77791_bV : Items.field_151055_y.func_77617_a(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getRenderContentID(IItemRenderer.ItemRenderType renderType, Object objectBeingRendered) {
        if (objectBeingRendered instanceof ItemStack) {
            return this.getRenderContentID((ItemStack)objectBeingRendered);
        }
        if (objectBeingRendered instanceof Item) {
            return this.getRenderContentID(new ItemStack((Item)objectBeingRendered));
        }
        if (objectBeingRendered instanceof Block) {
            return this.getRenderContentID(new ItemStack((Block)objectBeingRendered));
        }
        return this.getRenderContentID(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getRenderContentIDs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getRenderContentID(0));
        return list;
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rnd, WeightedRandomChestContent original) {
        return original;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack stack) {
        return 0;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int uses) {
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        try {
            if (stack != null) {
                ItemStack copy = stack.func_77946_l();
                ItemListenerIterator it = new ItemListenerIterator(this, "activation");
                while (it.hasNext()) {
                    IItemEventListener next = it.next();
                    if (!(next instanceof IItemActivationListener)) continue;
                    copy = ((IItemActivationListener)next).onItemRightClick(copy, world, player);
                }
                return copy;
            }
        }
        catch (Exception e) {
            player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + "Unexpected error using item, see logs for error details"));
            Engine.logger().error("ItemBase: Unexpected error triggering listeners during onItemRightClick(" + stack + ", " + player + ", " + world + ")");
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hit_x, float hit_y, float hit_z) {
        try {
            if (stack != null) {
                boolean clicked = false;
                ItemListenerIterator it = new ItemListenerIterator(this, "activation");
                while (it.hasNext()) {
                    IItemEventListener next = it.next();
                    if (!(next instanceof IItemActivationListener) || !((IItemActivationListener)next).onItemUse(stack, player, world, x, y, z, side, hit_x, hit_y, hit_z)) continue;
                    clicked = true;
                }
                return clicked;
            }
        }
        catch (Exception e) {
            player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + "Unexpected error using item, see logs for error details"));
            Engine.logger().error("ItemBase: Unexpected error triggering listeners during onItemUse(" + stack + ", " + player + ", " + world + ", " + x + ", " + y + ", " + z + ", " + side, (Throwable)e);
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hit_x, float hit_y, float hit_z) {
        try {
            if (stack != null) {
                boolean clicked = false;
                ItemListenerIterator it = new ItemListenerIterator(this, "activation");
                while (it.hasNext()) {
                    IItemEventListener next = it.next();
                    if (!(next instanceof IItemActivationListener)) continue;
                    clicked = ((IItemActivationListener)next).onItemUseFirst(stack, player, world, x, y, z, side, hit_x, hit_y, hit_z);
                }
                return clicked;
            }
        }
        catch (Exception e) {
            player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + "Unexpected error using item, see logs for error details"));
            Engine.logger().error("ItemBase: Unexpected error triggering listeners during onItemUseFirst(" + stack + ", " + player + ", " + world + ", " + x + ", " + y + ", " + z + ", " + side, (Throwable)e);
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        boolean clicked = false;
        ItemListenerIterator it = new ItemListenerIterator(this, "activation");
        while (it.hasNext()) {
            IItemEventListener next = it.next();
            if (!(next instanceof IItemActivationListener) || !((IItemActivationListener)next).doesSneakBypassUse(world, x, y, z, player)) continue;
            clicked = true;
        }
        return clicked;
    }

    @Override
    public void register(IJsonGenMod mod, ModManager manager) {
        if (!this.registered) {
            this.registered = true;
            manager.newItem(this.node.id, this);
            Engine.logger().info(this + " has been registered to " + mod);
            if (this.node.hasSubTypes()) {
                for (ItemNodeSubType type : this.node.subTypeHashMap.values()) {
                    if (type.oreName == null || type.oreName.isEmpty()) continue;
                    OreDictionary.registerOre((String)type.oreName, (ItemStack)new ItemStack((Item)this, 1, type.index));
                }
            }
        }
    }

    @Override
    public String getLoader() {
        return "item";
    }

    @Override
    public String getMod() {
        return this.node.owner;
    }

    @Override
    public String getContentID() {
        return this.getMod() + ":" + this.getUniqueID();
    }

    @Override
    public String getUniqueID() {
        return this.node.id;
    }

    public String getRenderContentID(ItemStack stack) {
        return this.getRenderContentID(stack.func_77960_j());
    }

    public String getRenderContentID(int meta) {
        return this.getMod() + ":" + this.node.getRenderContentID(meta);
    }

    @Override
    public void read(ByteBuf buf, EntityPlayer player, PacketType packet) {
        if (packet instanceof PacketPlayerItem) {
            int slot = ((PacketPlayerItem)packet).slotId;
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (stack != null) {
                if (stack.func_77973_b() == this) {
                    try {
                        this.node.readPacketData(buf, player, stack);
                    }
                    catch (Exception e) {
                        Engine.logger().error("ItemBase#read() >> Unexpected error while handling packet on stack[" + stack + "] item[" + stack.func_77973_b() + "] from packet[" + packet + "]", (Throwable)e);
                    }
                } else if (Engine.runningAsDev) {
                    Engine.logger().error("ItemBase#read() >> stack in slot[" + slot + "] item is not an instance of " + this + " can not read packet.");
                }
            } else if (Engine.runningAsDev) {
                Engine.logger().error("ItemBase#read() >> stack in slot[" + slot + "] item is null preventing packet reading.");
            }
        }
    }

    public PacketPlayerItem getPacket(int slotID, Object ... args) {
        return new PacketPlayerItem(slotID, args);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClassDisplayName());
        builder.append("(");
        this.toStringData(builder);
        builder.append(")@");
        builder.append(this.hashCode());
        return builder.toString();
    }

    protected String getClassDisplayName() {
        return this.getClass().getSimpleName();
    }

    protected void toStringData(StringBuilder builder) {
    }
}

