/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.processor;

import com.builtbroken.mc.client.json.render.block.RenderStateBlock;
import com.builtbroken.mc.client.json.render.processor.RenderJsonSubProcessor;
import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.data.Direction;
import com.google.gson.JsonObject;

public class BlockStateJsonProcessor
extends RenderJsonSubProcessor<RenderStateBlock> {
    public BlockStateJsonProcessor() {
        super(TextureData.Type.BLOCK);
    }

    @Override
    public RenderStateBlock process(JsonObject renderStateObject, String stateID, String globalRenderType, String subRenderType) {
        String key;
        RenderStateBlock renderState = new RenderStateBlock(stateID);
        if (renderStateObject.has("sides")) {
            key = renderStateObject.getAsJsonPrimitive("sides").getAsString();
            for (int i = 2; i < 6; ++i) {
                renderState.textureID[i] = key;
            }
        }
        if (renderStateObject.has("top")) {
            renderState.textureID[1] = key = renderStateObject.getAsJsonPrimitive("top").getAsString();
        }
        if (renderStateObject.has("bot")) {
            renderState.textureID[0] = key = renderStateObject.getAsJsonPrimitive("bot").getAsString();
        }
        if (renderStateObject.has("bottom")) {
            renderState.textureID[0] = key = renderStateObject.getAsJsonPrimitive("bottom").getAsString();
        }
        for (Direction direction : Direction.DIRECTIONS) {
            String key1 = "side:" + direction.ordinal();
            String key2 = direction.name().toLowerCase();
            if (renderStateObject.has(key1)) {
                renderState.textureID[direction.ordinal()] = renderStateObject.getAsJsonPrimitive(key1).getAsString();
                continue;
            }
            if (!renderStateObject.has(key2)) continue;
            renderState.textureID[direction.ordinal()] = renderStateObject.getAsJsonPrimitive(key2).getAsString();
        }
        return renderState;
    }

    @Override
    protected void setMainTexture(RenderStateBlock state, String key) {
        for (int i = 0; i < 6; ++i) {
            if (state.textureID[i] != null) continue;
            state.textureID[i] = key;
        }
    }

    @Override
    protected boolean hasTexture(RenderStateBlock state) {
        for (int i = 0; i < 6; ++i) {
            if (state.textureID[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canProcess(String type) {
        return type.equalsIgnoreCase("block");
    }
}

