/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import techguns.blocks.GenericBlock;
import techguns.util.BlockUtils;
import techguns.util.MBlock;

public class MultiMBlock
extends MBlock {
    Block[] blocks;
    int[] metas;
    int[] weights;
    BlockUtils.BlockType[] rotationTypes;
    boolean[] hasRotations;
    int totalWeight;

    public MultiMBlock(Block block, int meta) {
        super(block, meta);
    }

    public MultiMBlock(Block[] blocks, int[] metas, int[] weights, BlockUtils.BlockType[] rotationTypes, boolean[] hasRotations) {
        super(blocks[0], metas[0], hasRotations[0], rotationTypes[0]);
        this.blocks = blocks;
        this.metas = metas;
        this.weights = weights;
        this.rotationTypes = rotationTypes;
        this.hasRotations = hasRotations;
        this.calcTotalweight();
    }

    public MultiMBlock(Block[] blocks, int[] metas, int[] weights) {
        super(blocks[0], metas[0]);
        this.blocks = blocks;
        this.metas = metas;
        this.weights = weights;
        this.hasRotations = new boolean[blocks.length];
        this.calcTotalweight();
    }

    private void calcTotalweight() {
        this.totalWeight = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            this.totalWeight += this.weights[i];
        }
    }

    protected int rollBlockIndex() {
        int roll = RND.nextInt(this.totalWeight + 1);
        int sum = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            if (roll > (sum += this.weights[i])) continue;
            return i;
        }
        return this.weights.length;
    }

    public int getRotationMetaMulti(int rotationOffset, int index) {
        boolean hasRotationi = this.hasRotations[index];
        int metai = this.metas[index];
        if (hasRotationi) {
            switch (this.rotationTypes[index]) {
                case TG: {
                    if (this.block instanceof GenericBlock) {
                        return ((GenericBlock)this.block).getRotationMeta(metai, rotationOffset);
                    }
                    return metai;
                }
                case DOOR: {
                    int m = metai;
                    block55: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 0: {
                                m = 3;
                                continue block55;
                            }
                            case 3: {
                                m = 2;
                                continue block55;
                            }
                            case 2: {
                                m = 1;
                                continue block55;
                            }
                            case 1: {
                                m = 0;
                                continue block55;
                            }
                            case 7: {
                                m = 6;
                                continue block55;
                            }
                            case 6: {
                                m = 5;
                                continue block55;
                            }
                            case 5: {
                                m = 4;
                                continue block55;
                            }
                            case 4: {
                                m = 7;
                            }
                        }
                    }
                    return m;
                }
                case FENCE_GATE: {
                    if (metai < 4) {
                        return (metai + rotationOffset) % 4;
                    }
                    return 4 + (metai + rotationOffset) % 4;
                }
                case LADDER: {
                    int m = metai;
                    block56: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 5: {
                                m = 2;
                                continue block56;
                            }
                            case 4: {
                                m = 3;
                                continue block56;
                            }
                            case 3: {
                                m = 5;
                                continue block56;
                            }
                            case 2: {
                                m = 4;
                            }
                        }
                    }
                    return m;
                }
                case STAIRS: {
                    int m = metai;
                    block57: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 2: {
                                m = 0;
                                continue block57;
                            }
                            case 1: {
                                m = 2;
                                continue block57;
                            }
                            case 3: {
                                m = 1;
                                continue block57;
                            }
                            case 0: {
                                m = 3;
                                continue block57;
                            }
                            case 4: {
                                m = 7;
                                continue block57;
                            }
                            case 6: {
                                m = 4;
                                continue block57;
                            }
                            case 5: {
                                m = 6;
                                continue block57;
                            }
                            case 7: {
                                m = 5;
                            }
                        }
                    }
                    return m;
                }
                case BED: {
                    int m = metai;
                    block58: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 8: {
                                m = 11;
                                continue block58;
                            }
                            case 0: {
                                m = 3;
                                continue block58;
                            }
                            case 11: {
                                m = 10;
                                continue block58;
                            }
                            case 3: {
                                m = 2;
                                continue block58;
                            }
                            case 10: {
                                m = 9;
                                continue block58;
                            }
                            case 2: {
                                m = 1;
                                continue block58;
                            }
                            case 9: {
                                m = 8;
                                continue block58;
                            }
                            case 1: {
                                m = 0;
                            }
                        }
                    }
                    return m;
                }
                case STAIRS2_CHISEL: {
                    int m = metai;
                    block59: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 8: {
                                m = 11;
                                continue block59;
                            }
                            case 11: {
                                m = 9;
                                continue block59;
                            }
                            case 9: {
                                m = 10;
                                continue block59;
                            }
                            case 10: {
                                m = 8;
                                continue block59;
                            }
                            case 12: {
                                m = 15;
                                continue block59;
                            }
                            case 15: {
                                m = 13;
                                continue block59;
                            }
                            case 13: {
                                m = 14;
                                continue block59;
                            }
                            case 14: {
                                m = 12;
                            }
                        }
                    }
                    return m;
                }
            }
            return metai;
        }
        return metai;
    }

    @Override
    public void setBlock(World world, int posX, int posY, int posZ, int rotation) {
        if (this.isAirBlock()) {
            world.func_147468_f(posX, posY, posZ);
        } else {
            TileEntityChest tileentitychest;
            int index = this.rollBlockIndex();
            world.func_147465_d(posX, posY, posZ, this.blocks[index], this.getRotationMetaMulti(rotation, index), 2);
            if (this.block == Blocks.field_150486_ae && (tileentitychest = (TileEntityChest)world.func_147438_o(posX, posY, posZ)) != null) {
                WeightedRandomChestContent.func_76293_a((Random)RND, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)RND), (IInventory)tileentitychest, (int)ChestGenHooks.getCount((String)"dungeonChest", (Random)RND));
            }
        }
    }
}

