/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import techguns.Techguns;
import techguns.client.ClientProxy;
import techguns.entities.projectiles.GenericProjectile;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.guns.GenericGun;

public class GenericGunCharge
extends GenericGun {
    public float fullChargeTime = 20.0f;
    public int ammoConsumedOnFullCharge = 10;

    public GenericGunCharge() {
    }

    public GenericGunCharge(ItemStack ammo) {
        super(ammo);
    }

    public GenericGunCharge(String name, ItemStack ammo, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, String firesound, String reloadsound, int TTL, float accuracy, float fullChargeTime) {
        super(name, ammo, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy);
        this.fullChargeTime = fullChargeTime;
    }

    @Override
    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        TechgunsExtendedPlayerProperties extendedPlayer = TechgunsExtendedPlayerProperties.get(player);
        if (this.canZoom && player.func_70093_af() && this.toggleZoom) {
            if (world.field_72995_K) {
                ClientProxy cp = ClientProxy.get();
                cp.player_zoom = cp.player_zoom != 1.0f ? 1.0f : this.zoomMult;
            }
        } else {
            int ammo = this.getCurrentAmmo(item);
            if (ammo > 0) {
                int firedelay = extendedPlayer.fireDelay;
                if (firedelay <= 0) {
                    extendedPlayer.fireDelay = this.minFiretime;
                    player.func_71008_a(item, this.func_77626_a(item));
                    this.startCharge(item, world, player);
                }
            } else if (Techguns.consumeAmmoPlayer(player, this.ammo)) {
                if (this.emptyMag != null) {
                    player.field_71071_by.func_70441_a(new ItemStack(this.emptyMag.func_77973_b(), 1, this.emptyMag.func_77960_j()));
                }
                if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                    ClientProxy cp = ClientProxy.get();
                    if (cp.player_zoom != 1.0f) {
                        cp.player_zoom = 1.0f;
                    }
                }
                extendedPlayer.fireDelay = this.reloadtime - this.minFiretime;
                if (this.ammoCount > 1) {
                    int i;
                    for (i = 1; i < this.ammoCount && Techguns.consumeAmmoPlayer(player, this.ammo); ++i) {
                    }
                    this.reloadAmmo(item, i);
                } else {
                    this.reloadAmmo(item);
                }
                world.func_72956_a((Entity)player, this.reloadsound, 1.0f, 1.0f);
                if (world.field_72995_K) {
                    int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    ClientProxy cp = ClientProxy.get();
                    cp.setplayerReloadtime((EntityLivingBase)player, System.currentTimeMillis() + (long)time, time, (byte)1);
                    this.client_startReload();
                }
            } else if (!world.field_72995_K) {
                world.func_72956_a((Entity)player, "mob.villager.idle", 1.0f, 1.0f);
            }
        }
        return item;
    }

    protected void startCharge(ItemStack item, World world, EntityPlayer player) {
    }

    @Override
    public void func_77615_a(ItemStack item, World world, EntityPlayer player, int itemInUseCount) {
        int j = this.func_77626_a(item) - itemInUseCount;
        float f = (float)j / this.fullChargeTime;
        if (f > 1.0f) {
            f = 1.0f;
        }
        int ammoConsumed = this.consumeAmmoCharge(item, f, player.field_71075_bZ.field_75098_d);
        if (!world.field_72995_K) {
            this.spawnChargedProjectile(world, (EntityLivingBase)player, item, this.accuracy, f, ammoConsumed);
            if (this.shotgun) {
                for (int i = 0; i < this.bulletcount; ++i) {
                    this.spawnChargedProjectile(world, (EntityLivingBase)player, item, this.spread, f, ammoConsumed);
                }
            }
            world.func_72956_a((Entity)player, this.firesound, 1.0f, 1.0f);
            if (!this.rechamberSound.isEmpty()) {
                world.func_72956_a((Entity)player, this.rechamberSound, 1.0f, 1.0f);
            }
        } else {
            int recoiltime_l = this.getRecoilTime(f);
            long muzzleFlashtime_l = this.getMuzzleFlashTime(f);
            ClientProxy cp = ClientProxy.get();
            cp.setplayerRecoiltime((EntityLivingBase)player, System.currentTimeMillis() + (long)recoiltime_l, recoiltime_l, (byte)1);
            cp.player_muzzleFlashtime = System.currentTimeMillis() + muzzleFlashtime_l;
            cp.player_muzzleFlashtime_total = muzzleFlashtime_l;
            this.client_weaponFired();
        }
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 288000;
    }

    public int getRecoilTime(float charge) {
        return (int)((float)this.recoiltime / 20.0f * 1000.0f);
    }

    public long getMuzzleFlashTime(float charge) {
        return (long)((float)this.muzzleFlashtime / 20.0f * 1000.0f);
    }

    public int consumeAmmoCharge(ItemStack item, float f, boolean creative) {
        if (!creative) {
            this.useAmmo(item, 1);
        }
        return 1;
    }

    public void spawnChargedProjectile(World world, EntityLivingBase player, ItemStack itemStack, float spread, float charge, int ammoConsumed) {
        world.func_72838_d((Entity)new GenericProjectile(world, player, this.damage, this.speed, this.ticksToLive, spread, this.damageDropStart, this.damageDropEnd, this.damageMin, this.penetration, GenericGunCharge.getDoBlockDamage(player)));
    }
}

