/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npc.ITGNpcTeam;
import techguns.entities.npc.TGNpcFactions;
import techguns.util.EntityDeathUtils;

public class GenericProjectile
extends Entity
implements IProjectile {
    float damage;
    float speed = 1.0f;
    protected int ticksToLive = 100;
    protected int lifetime = 100;
    int damageDropStart;
    int damageDropEnd;
    float damageMin;
    protected EntityLivingBase shooter;
    float penetration = 0.0f;
    boolean silenced = false;
    protected boolean blockdamage = false;
    boolean posInitialized = false;
    double startX;
    double startY;
    double startZ;

    public GenericProjectile(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
    }

    private void initStartPos() {
        this.startX = this.field_70165_t;
        this.startY = this.field_70163_u;
        this.startZ = this.field_70161_v;
        this.posInitialized = true;
    }

    public GenericProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        this(par2World, p.field_70165_t, p.field_70163_u + (double)p.func_70047_e(), p.field_70161_v, p.field_70759_as, p.field_70125_A, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.shooter = p;
    }

    public GenericProjectile(World par2World, double posX, double posY, double posZ, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        this(par2World, posX, posY, posZ, 0.0f, 0.0f, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public GenericProjectile(World par2World, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World);
        this.field_70178_ae = true;
        this.shooter = null;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(posX, posY, posZ, yaw + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f, pitch + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
        motion.func_72432_b();
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.damage = damage;
        this.speed = speed;
        this.ticksToLive = TTL;
        this.lifetime = TTL;
        this.penetration = penetration;
        this.damageMin = dmgMin;
        this.damageDropStart = dmgDropStart;
        this.damageDropEnd = dmgDropEnd;
        this.blockdamage = blockdamage;
    }

    public GenericProjectile setSilenced() {
        this.silenced = true;
        return this;
    }

    protected int getTicksAlive() {
        return this.lifetime - this.ticksToLive;
    }

    protected double getDistanceTravelled() {
        Vec3 start = Vec3.func_72443_a((double)this.startX, (double)this.startY, (double)this.startZ);
        Vec3 end = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        return start.func_72438_d(end);
    }

    protected boolean isHeadshot(Entity ent, double height) {
        float threshold = 0.0f;
        if (ent instanceof EntityCreeper) {
            threshold = 1.6f;
        } else if (ent instanceof EntitySkeleton) {
            threshold = 1.6f;
        } else if (ent instanceof EntityZombie) {
            threshold = 1.6f;
        } else if (ent instanceof EntityEnderman) {
            threshold = 2.0f;
        }
        if (threshold > 0.0f) {
            return height > (double)threshold;
        }
        return false;
    }

    protected float getDamage() {
        double distance = this.getDistanceTravelled();
        double dropStart = this.damageDropStart;
        double dropEnd = this.damageDropEnd;
        if (distance <= dropStart) {
            return this.damage;
        }
        if (distance > dropEnd) {
            return this.damageMin;
        }
        float factor = 1.0f - (float)((distance - dropStart) / (dropEnd - dropStart));
        return this.damageMin + (this.damage - this.damageMin) * factor;
    }

    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeBulletDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.GORE);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    protected void hitBlock(MovingObjectPosition mop) {
        Block target = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        Material mat = target.func_149688_o();
        if (this.blockdamage && (mat == Material.field_151585_k || mat == Material.field_151582_l) && !this.field_70170_p.field_72995_K) {
            target.func_149697_b(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, this.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), 0);
            this.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        }
        this.spawnImpactParticle(mat);
    }

    protected void onHitEffect(EntityLivingBase ent) {
    }

    protected void setAIRevengeTarget(EntityLiving ent) {
        boolean shootBack = false;
        if (this.shooter != null) {
            if (this.shooter instanceof ITGNpcTeam && ent instanceof ITGNpcTeam) {
                shootBack = TGNpcFactions.isHostile(((ITGNpcTeam)this.shooter).getTGFaction(), ((ITGNpcTeam)ent).getTGFaction());
            } else if (!(this.shooter instanceof EntityPlayer)) {
                shootBack = true;
            }
        }
        if (shootBack) {
            ent.func_70604_c(this.shooter);
            ent.func_130011_c((Entity)this.shooter);
        }
    }

    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null) {
            TGDamageSource src = this.getProjectileDamageSource();
            TGDamageSource knockback = TGDamageSource.getKnockbackDummyDmgSrc(this, (Entity)this.shooter);
            if (par1MovingObjectPosition.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)par1MovingObjectPosition.field_72308_g;
                float dmg = DamageSystem.getDamageFactor(this.shooter, ent) * this.getDamage();
                if (dmg > 0.0f) {
                    ent.func_70097_a((DamageSource)knockback, 0.01f);
                    ent.func_70097_a((DamageSource)src, dmg);
                    if (ent instanceof EntityLiving) {
                        this.setAIRevengeTarget((EntityLiving)ent);
                    }
                    this.onHitEffect(ent);
                }
            } else {
                par1MovingObjectPosition.field_72308_g.func_70097_a((DamageSource)src, this.getDamage());
            }
            this.func_70106_y();
        }
        if (par1MovingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.hitBlock(par1MovingObjectPosition);
            this.func_70106_y();
        }
    }

    protected void spawnImpactParticle(Material mat) {
        if (mat == Material.field_151576_e) {
            this.field_70170_p.func_72956_a((Entity)this, "dig.stone", 2.0f, 1.0f);
            this.field_70170_p.func_72869_a("lava", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        } else if (mat == Material.field_151575_d) {
            this.field_70170_p.func_72956_a((Entity)this, "dig.wood", 2.0f, 1.0f);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        } else if (mat == Material.field_151592_s) {
            this.field_70170_p.func_72956_a((Entity)this, "dig.glass", 1.0f, 1.0f);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        } else if (mat == Material.field_151573_f || mat == Material.field_151574_g) {
            this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.hit", 1.0f, 1.0f);
            this.field_70170_p.func_72869_a("lava", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        } else {
            this.field_70170_p.func_72956_a((Entity)this, "techguns:effects.bulletimpact", 1.0f, 1.0f);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    public void shiftForward(float factor) {
        this.field_70165_t += this.field_70159_w * (double)factor;
        this.field_70163_u += this.field_70181_x * (double)factor;
        this.field_70161_v += this.field_70179_y * (double)factor;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float f2 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        this.field_70159_w = p_70186_1_ *= (double)p_70186_7_;
        this.field_70181_x = p_70186_3_ *= (double)p_70186_7_;
        this.field_70179_y = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
    }

    public void func_70071_h_() {
        if (!this.posInitialized && !this.field_70170_p.field_72995_K) {
            this.initStartPos();
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec31 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.shooter;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1 == entitylivingbase || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d) == Blocks.field_150427_aO) {
                this.func_70063_aa();
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.damage = tags.func_74760_g("damage");
        this.speed = tags.func_74760_g("speed");
        this.ticksToLive = tags.func_74762_e("ticksToLive");
        this.lifetime = tags.func_74762_e("lifetime");
        this.damageDropStart = tags.func_74762_e("damageDropStart");
        this.damageDropEnd = tags.func_74762_e("damageDropEnd");
        this.damageMin = tags.func_74760_g("damageMin");
    }

    protected void func_70014_b(NBTTagCompound tags) {
        tags.func_74776_a("damage", this.damage);
        tags.func_74776_a("speed", this.speed);
        tags.func_74768_a("ticksToLive", this.ticksToLive);
        tags.func_74768_a("lifetime", this.lifetime);
        tags.func_74768_a("damageDropStart", this.damageDropStart);
        tags.func_74768_a("damageDropEnd", this.damageDropEnd);
        tags.func_74776_a("damageMin", this.damageMin);
    }

    protected void func_70088_a() {
    }
}

