/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.entities.ai.EntityAIHurtByTargetTGFactions;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.ai.TurretEntityAINearestAttackableTarget;
import techguns.entities.ai.TurretEntityAIWatchClosest;
import techguns.entities.ai.TurretTargetSelector;
import techguns.entities.npc.INPCTechgunsShooter;
import techguns.entities.npc.ITGNpcTeam;
import techguns.entities.npc.TGNpcFaction;
import techguns.items.guns.GenericGun;
import techguns.packets.PacketRequestTurretSync;
import techguns.tileentities.TurretBaseEnt;

public class NPCTurret
extends EntityCreature
implements IAnimals,
IRangedAttackMob,
INPCTechgunsShooter,
ITGNpcTeam {
    private static final ResourceLocation texture_0 = new ResourceLocation("techguns:textures/blocks/TurretBase.png");
    private static final ResourceLocation texture_1 = new ResourceLocation("techguns:textures/blocks/TurretBase_2.png");
    private static final ResourceLocation texture_2 = new ResourceLocation("techguns:textures/blocks/TurretBase_3.png");
    private static final ResourceLocation texture_3 = new ResourceLocation("techguns:textures/blocks/TurretBase_4.png");
    private static final ResourceLocation texture_4 = new ResourceLocation("techguns:textures/blocks/TurretBase_5.png");
    protected TurretEntityAIWatchClosest aiWatch = null;
    protected EntityAILookIdle aiIdle = null;
    protected EntityAIHurtByTargetTGFactions aiHurt = null;
    protected TurretEntityAINearestAttackableTarget aiTarget = null;
    private EntityAIRangedAttack aiRangedAttack = null;
    public TurretBaseEnt mountedTileEnt;
    public boolean active = true;
    protected int networkUpdateRequestDelay = 0;

    public NPCTurret(World world) {
        super(world);
        this.setAITasks();
        this.mountedTileEnt = null;
        this.field_70131_O = 1.0f;
    }

    public NPCTurret(World world, TurretBaseEnt mountedTileEnt) {
        super(world);
        this.setAITasks();
        this.mountedTileEnt = mountedTileEnt;
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.field_70131_O = 1.0f;
    }

    public static ResourceLocation getTexture(int armor) {
        switch (armor) {
            case 5: {
                return texture_1;
            }
            case 10: {
                return texture_2;
            }
            case 15: {
                return texture_3;
            }
            case 20: {
                return texture_4;
            }
        }
        return texture_0;
    }

    public ResourceLocation getTexture() {
        return NPCTurret.getTexture(this.func_70658_aO());
    }

    public boolean func_70650_aV() {
        return true;
    }

    public float func_70047_e() {
        return 0.8f;
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
    }

    public boolean func_70686_a(Class target) {
        return true;
    }

    public ItemStack func_70694_bm() {
        return this.getWeapon();
    }

    protected ItemStack getWeapon() {
        if (this.mountedTileEnt != null) {
            return this.mountedTileEnt.getWeapon();
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return "mob.irongolem.hit";
    }

    protected String func_70673_aS() {
        return "mob.irongolem.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block block) {
    }

    public boolean func_70652_k(Entity target) {
        return super.func_70652_k(target);
    }

    public void func_70645_a(DamageSource damageSource) {
        this.mountedTileEnt.onTurretDeath();
    }

    protected void func_70600_l(int i1) {
    }

    protected void func_70628_a(boolean hitByPlayer, int level) {
    }

    protected ItemStack getRandomItemFromLoottable() {
        return null;
    }

    protected void func_82164_bB() {
    }

    public void setTileEnt(TurretBaseEnt ent) {
        this.mountedTileEnt = ent;
        this.setCombatTask();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70107_b(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        if (!this.field_70170_p.field_72995_K) {
            int z;
            int y;
            int x;
            TileEntity tile;
            if (this.mountedTileEnt == null && (tile = this.field_70170_p.func_147438_o(x = (int)Math.floor(this.field_70165_t), y = (int)Math.round(this.field_70163_u) - 1, z = (int)Math.floor(this.field_70161_v))) != null && tile instanceof TurretBaseEnt) {
                ((TurretBaseEnt)tile).setMountedTurret(this);
                this.mountedTileEnt = (TurretBaseEnt)tile;
                this.field_70170_p.func_147471_g(x, y, z);
                this.setCombatTask();
            }
        } else {
            if (this.networkUpdateRequestDelay > 0) {
                --this.networkUpdateRequestDelay;
            }
            if (this.mountedTileEnt == null && this.networkUpdateRequestDelay <= 0 && Techguns.proxy.clientInRangeSquared(this.field_70165_t, this.field_70161_v, 4096.0)) {
                TGPackets.network.sendToServer((IMessage)new PacketRequestTurretSync(this));
                this.networkUpdateRequestDelay = 600;
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (this.func_70694_bm() == null) {
            return;
        }
        Item gun = this.func_70694_bm().func_77973_b();
        if (gun instanceof GenericGun && this.mountedTileEnt != null && this.mountedTileEnt.consumeAmmo()) {
            ((GenericGun)gun).fireWeaponFromNPC((EntityLivingBase)this, 1.0f, 1.0f);
        }
    }

    public void func_70109_d(NBTTagCompound tags) {
        super.func_70109_d(tags);
    }

    public void func_70020_e(NBTTagCompound tags) {
        super.func_70020_e(tags);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void destroy() {
        this.func_70606_j(0.0f);
        this.func_70106_y();
    }

    public void setAITasks() {
        if (this.aiWatch == null) {
            this.aiWatch = new TurretEntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 80.0f, 20.0);
        }
        if (this.aiIdle == null) {
            this.aiIdle = new EntityAILookIdle((EntityLiving)this);
        }
        if (this.aiHurt == null) {
            this.aiHurt = new EntityAIHurtByTargetTGFactions(this, false);
        }
        if (this.aiTarget == null) {
            this.aiTarget = new TurretEntityAINearestAttackableTarget(this, EntityLivingBase.class, 0, true, false, new TurretTargetSelector(this), 20.0);
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiWatch);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiIdle);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiHurt);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiTarget);
    }

    public void disable() {
        this.active = false;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiIdle);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurt);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiTarget);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
        ItemStack itemstack = this.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof GenericGun) {
            GenericGun gun = (GenericGun)itemstack.func_77973_b();
            this.aiRangedAttack = gun.getAIAttack(this);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiRangedAttack);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)gun.getAI_attackRange());
        }
    }

    public int func_70658_aO() {
        if (this.mountedTileEnt != null) {
            return this.mountedTileEnt.getTurretArmorValue();
        }
        return 0;
    }

    @Override
    public float getWeaponPosX() {
        return 0.05f;
    }

    @Override
    public float getWeaponPosY() {
        return 0.7f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.8f;
    }

    @Override
    public TGNpcFaction getTGFaction() {
        return TGNpcFaction.TURRET;
    }
}

