/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;

public class EntityAIRangedAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private double entityMoveSpeed;
    private int ticksTargetSeen;
    private int attackTimeVariance;
    private int maxRangedAttackTime;
    private float attackRange;
    private float attackRange_2;
    private int maxBurstCount;
    private int burstCount;
    private int shotDelay;

    public EntityAIRangedAttack(IRangedAttackMob shooter, double moveSpeed, int attackTimeVariance, int attackTime, float attackRange, int maxBurstCount, int shotDelay) {
        if (!(shooter instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = shooter;
        this.entityHost = (EntityLiving)shooter;
        this.entityMoveSpeed = moveSpeed;
        this.attackTimeVariance = attackTimeVariance;
        this.maxRangedAttackTime = attackTime;
        this.attackRange = attackRange;
        this.attackRange_2 = attackRange * attackRange;
        this.func_75248_a(3);
        this.maxBurstCount = maxBurstCount;
        this.burstCount = maxBurstCount;
        this.shotDelay = shotDelay;
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.ticksTargetSeen = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean targetInSight = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.ticksTargetSeen = targetInSight ? ++this.ticksTargetSeen : 0;
        if (d0 <= (double)this.attackRange_2 && this.ticksTargetSeen >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            float f;
            if (d0 > (double)this.attackRange_2 || !targetInSight) {
                return;
            }
            float f1 = f = MathHelper.func_76133_a((double)d0) / this.attackRange;
            if (f < 0.1f) {
                f1 = 0.1f;
            }
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, f1);
            if (this.maxBurstCount > 0) {
                --this.burstCount;
            }
            if (this.burstCount > 0) {
                this.rangedAttackTime = this.shotDelay;
            } else {
                this.burstCount = this.maxBurstCount;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackTimeVariance) + (float)this.attackTimeVariance));
            }
        } else if (this.rangedAttackTime < 0) {
            float f = MathHelper.func_76133_a((double)d0) / this.attackRange;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackTimeVariance) + (float)this.attackTimeVariance));
        }
    }
}

