/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import techguns.client.renderer.TGRenderHelper;
import techguns.entities.projectiles.TeslaBeam;

public class RenderTeslaBeam
extends Render {
    private static final ResourceLocation LaserTextures = new ResourceLocation("techguns:textures/fx/laser_blue.png");
    double offset = 0.2;
    int sinCount = 5;
    double WIDTH = 0.5;
    double SIN_DISTANCE = 10.0;
    double xOffset;
    private int maxTicks = 10;

    public RenderTeslaBeam(double xOffset) {
        this.xOffset = xOffset;
    }

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        TeslaBeam laser = (TeslaBeam)par1Entity;
        Random rand = new Random(laser.seed);
        double distance = laser.beamlength;
        double[] dY = new double[this.sinCount];
        double[] dZ = new double[this.sinCount];
        for (int i = 0; i < this.sinCount; ++i) {
            dY[i] = 0.5 - rand.nextDouble();
            dZ[i] = 0.5 - rand.nextDouble();
        }
        float progress = (float)par1Entity.field_70173_aa / (float)this.maxTicks;
        int count = (int)Math.round((distance -= this.xOffset) / this.offset);
        this.offset = distance / (double)count;
        int xreps = Math.max(1, (int)Math.round(distance / this.SIN_DISTANCE));
        double xprev = 0.0;
        double yprev = 0.0;
        double zprev = 0.0;
        double widthprev = 1.0;
        double alphaprev = 1.0;
        this.func_110777_b(par1Entity);
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        GL11.glRotatef((float)(-(par1Entity.field_70177_z + 90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-par1Entity.field_70125_A), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        TGRenderHelper.enableAlphaBlendAdditive();
        TGRenderHelper.enableFXLighting();
        for (int i = 0; i <= count; ++i) {
            double d = (double)i / (double)count;
            double x = this.xOffset + (double)i * this.offset;
            double y = 0.0;
            double z = 0.0;
            double randomness = 0.0;
            if (i > 1) {
                for (int j = 1; j <= this.sinCount; ++j) {
                    double yfactor = (rand.nextDouble() - 0.5 + (double)progress * dY[j - 1] * 1.0) * (2.0 / (double)j);
                    double zfactor = (rand.nextDouble() - 0.5 + (double)progress * dZ[j - 1] * 1.0) * (2.0 / (double)j);
                    y += Math.sin(d * Math.PI * (double)(j * xreps)) * yfactor;
                    z += Math.sin(d * Math.PI * (double)(j * xreps)) * zfactor;
                }
            }
            double pulse = 1.0 - Math.sqrt(Math.abs((double)progress - d) * 2.0);
            double width = Math.max(0.0, this.WIDTH * pulse);
            if (i >= 1) {
                this.drawSegment(tessellator, xprev, yprev, zprev, x, y, z, widthprev, width, alphaprev, pulse);
            }
            widthprev = width;
            alphaprev = pulse;
            xprev = x;
            yprev = y;
            zprev = z;
        }
        TGRenderHelper.disableFXLighting();
        TGRenderHelper.disableAlphaBlend();
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    void drawSegment(Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2, double width1, double width2, double a1, double a2) {
        double scale = 0.5;
        y1 *= scale;
        y2 *= scale;
        z1 *= scale;
        z2 *= scale;
        width1 *= scale;
        width2 *= scale;
        GL11.glPushMatrix();
        GL11.glRotated((double)45.0, (double)1.0, (double)0.0, (double)0.0);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, (float)a1);
        tessellator.func_78382_b();
        tessellator.func_78374_a(x1, y1 - width1, z1, 0.0, 0.0);
        tessellator.func_78374_a(x1, y1 + width1, z1, 0.0, 1.0);
        tessellator.func_78374_a(x2, y2 + width2, z2, 1.0, 1.0);
        tessellator.func_78374_a(x2, y2 - width2, z2, 1.0, 0.0);
        tessellator.func_78381_a();
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, (float)a2);
        tessellator.func_78382_b();
        tessellator.func_78374_a(x1, y1, z1 - width1, 0.0, 0.0);
        tessellator.func_78374_a(x1, y1, z1 + width1, 0.0, 1.0);
        tessellator.func_78374_a(x2, y2, z2 + width2, 1.0, 1.0);
        tessellator.func_78374_a(x2, y2, z2 - width2, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return LaserTextures;
    }
}

