/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.blocks.BlockLumos;
import taintedmagic.common.entities.EntityGlowpet;
import taintedmagic.common.items.wand.foci.FocusUpgrades;
import taintedmagic.common.registry.BlockRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSparkle;
import thaumcraft.client.fx.particles.FXWisp;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusLumos
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.AIR, 500).add(Aspect.FIRE, 500);
    private static final AspectList costGlowpet = new AspectList().add(Aspect.ORDER, 500).add(Aspect.AIR, 500).add(Aspect.FIRE, 1000);
    private static final AspectList costMaxima = new AspectList().add(Aspect.ORDER, 1000).add(Aspect.FIRE, 1500).add(Aspect.AIR, 500);

    public ItemFocusLumos() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusLumos");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusLumos");
    }

    public String getSortingHelper(ItemStack s) {
        return "GLOWPET" + super.getSortingHelper(s);
    }

    public int getFocusColor(ItemStack s) {
        return 16761468;
    }

    public void func_77624_a(ItemStack s, EntityPlayer p, List l, boolean b) {
        super.func_77624_a(s, p, l, b);
        if (this.isUpgradedWith(s, FocusUpgrades.maxima)) {
            l.add(" ");
            l.add(EnumChatFormatting.BLUE + "+" + new String(this.isUpgradedWith(s, FocusUpgradeType.enlarge) ? Integer.toString(11 + this.getUpgradeLevel(s, FocusUpgradeType.enlarge)) : "11") + " " + StatCollector.func_74838_a((String)"text.radius"));
        }
        if (this.isUpgradedWith(s, FocusUpgrades.glowpet)) {
            l.add(" ");
            l.add(EnumChatFormatting.BLUE + new String(this.isUpgradedWith(s, FocusUpgradeType.extend) ? Integer.toString(1 + this.getUpgradeLevel(s, FocusUpgradeType.extend)) : "1") + "x " + StatCollector.func_74838_a((String)"text.burnTime"));
        }
    }

    public AspectList getVisCost(ItemStack s) {
        return this.isUpgradedWith(s, FocusUpgrades.maxima) ? costMaxima : (this.isUpgradedWith(s, FocusUpgrades.glowpet) ? costGlowpet : cost);
    }

    public int getActivationCooldown(ItemStack s) {
        return 1000;
    }

    public boolean isVisCostPerTick(ItemStack s) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack s) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack s, World w, EntityPlayer p, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)s.func_77973_b();
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !p.func_70093_af()) {
            if (wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
                int x = mop.field_72311_b;
                int y = mop.field_72312_c;
                int z = mop.field_72309_d;
                switch (mop.field_72310_e) {
                    case 0: {
                        --y;
                        break;
                    }
                    case 1: {
                        ++y;
                        break;
                    }
                    case 2: {
                        --z;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                    case 4: {
                        --x;
                        break;
                    }
                    case 5: {
                        ++x;
                    }
                }
                if (!w.field_72995_K) {
                    w.func_147465_d(x, y, z, BlockRegistry.BlockLumos, 2, 3);
                }
                w.func_72956_a((Entity)p, "thaumcraft:ice", 0.3f, 1.1f + w.field_73012_v.nextFloat() * 0.1f);
                for (int a = 0; a < 9; ++a) {
                    if (!w.field_72995_K) continue;
                    this.spawnLumosParticles(w, x, y, z);
                }
            }
        } else if (this.isUpgradedWith(wand.getFocusItem(s), FocusUpgrades.glowpet)) {
            if (wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
                EntityGlowpet pet = new EntityGlowpet(w, (EntityLivingBase)p, wand.getFocusExtend(s) + 1);
                if (!w.field_72995_K) {
                    w.func_72838_d((Entity)pet);
                }
                w.func_72956_a((Entity)pet, "taintedmagic:shard", 0.3f, 1.1f + w.field_73012_v.nextFloat() * 0.1f);
                for (int a = 0; a < 18; ++a) {
                    if (!w.field_72995_K) continue;
                    this.spawnLumosParticles(w, pet.field_70165_t, pet.field_70163_u, pet.field_70161_v);
                }
            }
        } else if (this.isUpgradedWith(wand.getFocusItem(s), FocusUpgrades.maxima)) {
            int r = 11 + wand.getFocusEnlarge(s);
            if (wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
                for (int xOff = -r; xOff <= r; ++xOff) {
                    for (int yOff = -r; yOff <= r; ++yOff) {
                        for (int zOff = -r; zOff <= r; ++zOff) {
                            int x = (int)(p.field_70165_t + (double)xOff);
                            int y = (int)(p.field_70163_u + (double)yOff);
                            int z = (int)(p.field_70161_v + (double)zOff);
                            if (!w.func_147437_c(x, y, z) || w.func_147439_a(x, y, z) == BlockRegistry.BlockLumos || w.func_72957_l(x, y, z) >= 9) continue;
                            BlockLumos src = (BlockLumos)BlockRegistry.BlockLumos;
                            src.setGlowDuration(200);
                            if (w.field_72995_K) continue;
                            w.func_147465_d(x, y, z, (Block)src, 1, 3);
                        }
                    }
                    if (!w.field_72995_K) continue;
                    this.spawnMaximaParticles(w, p, wand.getFocusEnlarge(s));
                }
                w.func_72956_a((Entity)p, "thaumcraft:runicShieldCharge", 0.3f, 1.0f + w.field_73012_v.nextFloat() * 0.5f);
            }
        }
        p.func_71038_i();
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    void spawnLumosParticles(World w, double x, double y, double z) {
        FXSparkle fx = new FXSparkle(w, x + (double)w.field_73012_v.nextFloat(), y + (double)w.field_73012_v.nextFloat(), z + (double)w.field_73012_v.nextFloat(), 1.75f, 6, 3 + w.field_73012_v.nextInt(3));
        fx.setGravity(0.1f);
        ParticleEngine.instance.addEffect(w, (EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    void spawnMaximaParticles(World w, EntityPlayer p, float ex) {
        int i = 1;
        while ((float)i < 100.0f + 25.0f * ex) {
            double t = Math.PI * 2 * Math.random();
            double r = (-Math.random() + Math.random()) * (double)(11.0f + ex);
            double xp = r * Math.cos(t);
            double zp = r * Math.sin(t);
            double yp = -Math.random() + Math.random();
            double off = Math.random() * 0.1;
            float red = 0.9f + (float)Math.random() * 0.1f;
            float green = 0.8f + (float)Math.random() * 0.1f;
            float blue = 0.8f + (float)Math.random() * 0.1f;
            FXWisp ef = new FXWisp(w, p.field_70165_t + xp + off, p.field_70163_u + 5.0 + yp + off, p.field_70161_v + zp + off, 0.5f + (float)Math.random() * 0.25f, red, green, blue);
            ef.setGravity(0.0f);
            ef.shrink = true;
            ef.field_70145_X = false;
            ef.func_70024_g(r * Math.cos(t + Math.PI) * 0.1, 0.0, r * Math.sin(t + Math.PI) * 0.1);
            ParticleEngine.instance.addEffect(w, (EntityFX)ef);
            ++i;
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack s, int r) {
        switch (r) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgrades.glowpet, FocusUpgrades.maxima, FocusUpgradeType.frugal};
            }
            case 2: {
                if (this.isUpgradedWith(s, FocusUpgrades.glowpet)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.extend};
                }
                if (this.isUpgradedWith(s, FocusUpgrades.maxima)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
                }
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 3: {
                if (this.isUpgradedWith(s, FocusUpgrades.glowpet)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.extend};
                }
                if (this.isUpgradedWith(s, FocusUpgrades.maxima)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
                }
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 4: {
                if (this.isUpgradedWith(s, FocusUpgrades.glowpet)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.extend};
                }
                if (this.isUpgradedWith(s, FocusUpgrades.maxima)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
                }
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 5: {
                if (this.isUpgradedWith(s, FocusUpgrades.glowpet)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.extend};
                }
                if (this.isUpgradedWith(s, FocusUpgrades.maxima)) {
                    return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
                }
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
        }
        return null;
    }
}

