/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityTaintBubble
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public static final String TAG_DAMAGE = "dmg";
    public boolean corrosive = false;
    public float dmg = 0.0f;
    public float red = 0.0f;
    public float green = 0.0f;
    public float blue = 0.0f;

    public EntityTaintBubble(World w) {
        super(w);
    }

    public EntityTaintBubble(World w, EntityLivingBase e, float scatter, float dmg, boolean corrosive) {
        super(w, e);
        this.corrosive = corrosive;
        this.dmg = dmg;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), scatter);
        this.red = 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f;
        this.green = this.field_70170_p.field_73012_v.nextFloat() * 0.2f;
        this.blue = 1.0f - this.field_70170_p.field_73012_v.nextFloat() * 0.2f;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    public void func_70071_h_() {
        this.field_70159_w *= 0.95;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.95;
        ChunkCoordinates c = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        double varX = (double)c.field_71574_a + 0.5 - this.field_70165_t;
        double varY = (double)c.field_71572_b + 0.1 - this.field_70163_u;
        double varZ = (double)c.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(varX) * 0.5 - this.field_70159_w) * 0.02;
        this.field_70181_x += (Math.signum(varY) * 0.7 - this.field_70181_x) * 0.05;
        this.field_70179_y += (Math.signum(varZ) * 0.5 - this.field_70179_y) * 0.02;
        float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float wrappedAngle = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
        this.field_70177_z += wrappedAngle;
        if (this.field_70173_aa > 50) {
            this.func_70106_y();
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.65;
            this.field_70181_x *= 0.65;
            this.field_70179_y *= 0.65;
        }
        super.func_70071_h_();
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.dmg);
        buf.writeFloat(this.red);
        buf.writeFloat(this.green);
        buf.writeFloat(this.blue);
    }

    public void readSpawnData(ByteBuf buf) {
        this.dmg = buf.readFloat();
        this.red = buf.readFloat();
        this.green = buf.readFloat();
        this.blue = buf.readFloat();
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K && this.func_85052_h() != null) {
            List l = this.field_70170_p.func_72839_b((Entity)this.func_85052_h(), this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            for (int i = 0; i < l.size(); ++i) {
                Entity e = (Entity)l.get(i);
                if (!(e instanceof EntityLivingBase) || mop.field_72308_g == null) continue;
                ((EntityLivingBase)e).func_70097_a(new EntityDamageSourceIndirect("taint", (Entity)this, (Entity)this.func_85052_h()).func_82726_p(), this.dmg);
                if (this.corrosive) {
                    try {
                        ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 1));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                try {
                    ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 1));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.func_70106_y();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.1f;
    }

    public void func_70014_b(NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74776_a(TAG_DAMAGE, this.dmg);
    }

    public void func_70037_a(NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.dmg = cmp.func_74762_e(TAG_DAMAGE);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource s, float f) {
        return false;
    }
}

