/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.world;

import WayofTime.alchemicalWizardry.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkProviderSNDimension
implements IChunkProvider {
    private static final String __OBFID = "CL_00000391";
    private final Block[] cachedBlockIDs = new Block[256];
    private final byte[] cachedBlockMetadata = new byte[256];
    private final FlatGeneratorInfo flatWorldGenInfo;
    private final List structureGenerators = new ArrayList();
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private World worldObj;
    private Random random;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;

    public ChunkProviderSNDimension(World p_i2004_1_, long p_i2004_2_, boolean p_i2004_4_, String p_i2004_5_) {
        this.worldObj = p_i2004_1_;
        this.random = new Random(p_i2004_2_);
        this.flatWorldGenInfo = FlatGeneratorInfo.func_82651_a((String)p_i2004_5_);
        if (p_i2004_4_) {
            Map map = this.flatWorldGenInfo.func_82644_b();
            if (map.containsKey("village")) {
                Map map1 = (Map)map.get("village");
                if (!map1.containsKey("size")) {
                    map1.put("size", "1");
                }
                this.structureGenerators.add(new MapGenVillage(map1));
            }
            if (map.containsKey("biome_1")) {
                this.structureGenerators.add(new MapGenScatteredFeature((Map)map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.structureGenerators.add(new MapGenMineshaft((Map)map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.structureGenerators.add(new MapGenStronghold((Map)map.get("stronghold")));
            }
        }
        this.hasDecoration = this.flatWorldGenInfo.func_82644_b().containsKey("decoration");
        if (this.flatWorldGenInfo.func_82644_b().containsKey("lake")) {
            this.waterLakeGenerator = new WorldGenLakes(Blocks.field_150355_j);
        }
        if (this.flatWorldGenInfo.func_82644_b().containsKey("lava_lake")) {
            this.lavaLakeGenerator = new WorldGenLakes(Blocks.field_150353_l);
        }
        this.hasDungeons = this.flatWorldGenInfo.func_82644_b().containsKey("dungeon");
        for (FlatLayerInfo flatlayerinfo : this.flatWorldGenInfo.func_82650_c()) {
            for (int j = flatlayerinfo.func_82656_d(); j < flatlayerinfo.func_82656_d() + flatlayerinfo.func_82657_a(); ++j) {
                this.cachedBlockIDs[j] = j == 0 ? Blocks.field_150357_h : ModBlocks.bloodStoneBrick;
                this.cachedBlockMetadata[j] = (byte)flatlayerinfo.func_82658_c();
            }
        }
    }

    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        return this.func_73154_d(p_73158_1_, p_73158_2_);
    }

    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        int l;
        Chunk chunk = new Chunk(this.worldObj, p_73154_1_, p_73154_2_);
        for (int k = 0; k < this.cachedBlockIDs.length; ++k) {
            Block block = this.cachedBlockIDs[k];
            if (block == null) continue;
            l = k >> 4;
            ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
            if (extendedblockstorage == null) {
                chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(k, !this.worldObj.field_73011_w.field_76576_e);
            }
            for (int i1 = 0; i1 < 16; ++i1) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    extendedblockstorage.func_150818_a(i1, k & 0xF, j1, block);
                    extendedblockstorage.func_76654_b(i1, k & 0xF, j1, (int)this.cachedBlockMetadata[k]);
                }
            }
        }
        chunk.func_76603_b();
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, p_73154_1_ * 16, p_73154_2_ * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)abiomegenbase[l].field_76756_M;
        }
        for (MapGenBase mapgenbase : this.structureGenerators) {
            mapgenbase.func_151539_a((IChunkProvider)this, this.worldObj, p_73154_1_, p_73154_2_, (Block[])null);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int j2;
        int i2;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        boolean flag = false;
        this.random.setSeed(this.worldObj.func_72905_C());
        long i1 = this.random.nextLong() / 2L * 2L + 1L;
        long j1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ this.worldObj.func_72905_C());
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            boolean flag1 = mapgenstructure.func_75051_a(this.worldObj, this.random, p_73153_2_, p_73153_3_);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            int l1 = k + this.random.nextInt(16) + 8;
            i2 = this.random.nextInt(256);
            j2 = l + this.random.nextInt(16) + 8;
            this.waterLakeGenerator.func_76484_a(this.worldObj, this.random, l1, i2, j2);
        }
        if (this.lavaLakeGenerator != null && !flag && this.random.nextInt(8) == 0) {
            int l1 = k + this.random.nextInt(16) + 8;
            i2 = this.random.nextInt(this.random.nextInt(248) + 8);
            j2 = l + this.random.nextInt(16) + 8;
            if (i2 < 63 || this.random.nextInt(10) == 0) {
                this.lavaLakeGenerator.func_76484_a(this.worldObj, this.random, l1, i2, j2);
            }
        }
        if (this.hasDungeons) {
            for (int l1 = 0; l1 < 8; ++l1) {
                i2 = k + this.random.nextInt(16) + 8;
                j2 = this.random.nextInt(256);
                int k1 = l + this.random.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(this.worldObj, this.random, i2, j2, k1);
            }
        }
        if (this.hasDecoration) {
            biomegenbase.func_76728_a(this.worldObj, this.random, k, l);
        }
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "FlatLevelSource";
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
        return biomegenbase.func_76747_a(p_73155_1_);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        if ("Stronghold".equals(p_147416_2_)) {
            for (MapGenStructure mapgenstructure : this.structureGenerators) {
                if (!(mapgenstructure instanceof MapGenStronghold)) continue;
                return mapgenstructure.func_151545_a(p_147416_1_, p_147416_3_, p_147416_4_, p_147416_5_);
            }
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_151539_a((IChunkProvider)this, this.worldObj, p_82695_1_, p_82695_2_, (Block[])null);
        }
    }
}

