/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.util;

import WayofTime.alchemicalWizardry.ModItems;
import com.google.common.base.Strings;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.objects.BlockAndMetadata;
import tombenpotter.sanguimancy.api.objects.MapKey;
import tombenpotter.sanguimancy.registry.ItemsRegistry;
import tombenpotter.sanguimancy.util.ConfigHandler;
import tombenpotter.sanguimancy.world.WorldProviderSoulNetworkDimension;

public class RandomUtils {
    public static HashMap<String, Integer> oreDictColor = new HashMap();
    public static Item.ToolMaterial corruptedMaterial = EnumHelper.addToolMaterial((String)"corruptedToolMaterial", (int)Integer.MAX_VALUE, (int)9000, (float)32.0f, (float)10.0f, (int)32);
    public static HashMap<MapKey, ItemStack> logToPlank = new HashMap();
    public static ArrayList<ItemStack> oreLumpList = new ArrayList();
    public static ArrayList<BlockAndMetadata> transpositionBlockBlacklist = new ArrayList();
    public static ArrayList<BlockAndMetadata> teleposerBlacklist = new ArrayList();

    public static void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public static EntityItem dropItemStackInWorld(World world, double x, double y, double z, ItemStack stack) {
        if (!world.field_72995_K) {
            float f = 0.7f;
            float d0 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(world, x + (double)d0, y + (double)d1, z + (double)d2, stack);
            entityitem.field_145804_b = 1;
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public static NBTTagCompound checkAndSetCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77982_d(tag);
            return tag;
        }
        return null;
    }

    public static String capitalizeFirstLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void addOreDictColors() {
        oreDictColor.put("Gold", new Color(255, 255, 0).getRGB());
        oreDictColor.put("Iron", new Color(255, 204, 204).getRGB());
        oreDictColor.put("Copper", new Color(204, 102, 51).getRGB());
        oreDictColor.put("Tin", new Color(135, 154, 168).getRGB());
        oreDictColor.put("Lead", new Color(102, 102, 153).getRGB());
        oreDictColor.put("Ardite", new Color(255, 102, 0).getRGB());
        oreDictColor.put("Cobalt", new Color(0, 60, 255).getRGB());
        oreDictColor.put("Nickel", new Color(204, 204, 204).getRGB());
        oreDictColor.put("Silver", new Color(187, 189, 184).getRGB());
        oreDictColor.put("Platinum", new Color(30, 208, 243).getRGB());
        oreDictColor.put("Aluminium", new Color(198, 206, 130).getRGB());
        oreDictColor.put("Aluminum", new Color(198, 206, 130).getRGB());
        oreDictColor.put("Uranium", new Color(90, 159, 50).getRGB());
    }

    public static boolean fillContainerFromHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        ItemStack container = player.func_71045_bC();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            ItemStack returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)returnStack);
            if (fluid == null || returnStack == null) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (container.field_77994_a == 1) {
                    container = container.func_77946_l();
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                } else if (!player.field_71071_by.func_70441_a(returnStack)) {
                    return false;
                }
                handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                --container.field_77994_a;
                if (container.field_77994_a <= 0) {
                    container = null;
                }
            } else {
                handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean fillHandlerWithContainer(World world, IFluidHandler handler, EntityPlayer player) {
        ItemStack container = player.func_71045_bC();
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null && (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d)) {
            if (world.field_72995_K) {
                return true;
            }
            handler.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, RandomUtils.consumeItem(container));
            }
            return true;
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null) {
                return null;
            }
            if (ret.func_77984_f() && ret.func_77960_j() > ret.func_77958_k()) {
                ret = null;
            }
            return ret;
        }
        return largerStack ? stack : null;
    }

    public static boolean areStacksEqual(ItemStack[] stack1, ItemStack[] stack2, boolean exactAmountAndNBT) {
        if (stack1.length != stack2.length) {
            return false;
        }
        if (exactAmountAndNBT) {
            for (int i = 0; i < stack1.length; ++i) {
                if (stack1[i] == stack2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < stack1.length; ++i) {
                if (stack1[i].func_77969_a(stack2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static String addStringToEnd(String input, String toAdd) {
        return input + toAdd;
    }

    public static void writeLog(String string, String fileName) {
        try {
            File log = new File(String.valueOf(DimensionManager.getCurrentSaveRootDirectory()) + "/" + "sanguimancy" + "/" + fileName);
            if (!log.exists()) {
                if (log.getParentFile().mkdir()) {
                    if (log.createNewFile()) {
                        Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                    }
                } else if (log.createNewFile()) {
                    Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                } else {
                    throw new IOException("Failed to create directory " + log.getParent());
                }
            }
            FileWriter fileWriter = new FileWriter(log.getAbsoluteFile(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException e) {
            Sanguimancy.logger.error(fileName + " was not found in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
        }
    }

    public static void fireEvent(Event event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    public static void unbindItemStack(ItemStack stack) {
        RandomUtils.checkAndSetCompound(stack);
        if (stack.field_77990_d.func_74764_b("ownerName") && !stack.field_77990_d.func_74779_i("ownerName").equals("")) {
            stack.field_77990_d.func_74778_a("ownerName", "");
        }
    }

    public static String getItemOwner(ItemStack stack) {
        RandomUtils.checkAndSetCompound(stack);
        try {
            return stack.field_77990_d.func_74779_i("ownerName");
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static void createSNDimension() {
        int dimID = ConfigHandler.snDimID;
        if (!DimensionManager.isDimensionRegistered((int)dimID)) {
            WorldProviderSoulNetworkDimension provider = new WorldProviderSoulNetworkDimension();
            provider.setDimension(dimID);
            DimensionManager.registerProviderType((int)dimID, ((Object)((Object)provider)).getClass(), (boolean)true);
            DimensionManager.registerDimension((int)dimID, (int)dimID);
        }
    }

    public static void dropBlockDropsWithFortune(World world, Block block, int x, int y, int z, int metadata, int fortune) {
        if (block != null && block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0) != null) {
            for (ItemStack stack : block.getDrops(world, x, y, z, metadata, fortune)) {
                RandomUtils.dropItemStackInWorld(world, x, y, z, stack.func_77946_l());
            }
        }
    }

    public static void dropSilkDrops(World world, Block block, int x, int y, int z, int metadata) {
        if (block != null && block.canSilkHarvest(world, null, x, y, z, metadata)) {
            ItemStack copyStack = new ItemStack(block, 1, world.func_72805_g(x, y, z)).func_77946_l();
            RandomUtils.dropItemStackInWorld(world, x, y, z, copyStack);
        } else {
            RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
        }
    }

    public static void dropSmeltDrops(World world, Block block, int x, int y, int z, int metadata) {
        if (block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0) != null) {
            for (ItemStack stack : block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
                ItemStack copyStack = stack.func_77946_l();
                if (FurnaceRecipes.func_77602_a().func_151395_a(copyStack) == null) {
                    RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                    continue;
                }
                ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                RandomUtils.dropItemStackInWorld(world, x, y, z, output);
            }
        }
    }

    public static ArrayList<String> getItemStackName(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static void renderBlock(RenderWorldLastEvent event, EntityPlayer player, World world, Block block, int metadata, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78380_c(block.func_149677_c((IBlockAccess)world, x, y + 1, z));
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        double minX = (double)x - px;
        double minY = (double)y - py;
        double minZ = (double)z - pz;
        double maxX = minX + 1.0;
        double maxY = minY + 1.0;
        double maxZ = minZ + 1.0;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(0));
        float textureMinU = block.func_149691_a(0, metadata).func_94209_e();
        float textureMinV = block.func_149691_a(0, metadata).func_94206_g();
        float textureMaxU = block.func_149691_a(0, metadata).func_94212_f();
        float textureMaxV = block.func_149691_a(0, metadata).func_94210_h();
        tessellator.func_78374_a(minX, minY, minZ, (double)textureMinU, (double)textureMinV);
        tessellator.func_78374_a(maxX, minY, minZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(maxX, minY, maxZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(minX, minY, maxZ, (double)textureMinU, (double)textureMaxV);
        textureMinU = block.func_149691_a(1, metadata).func_94209_e();
        textureMinV = block.func_149691_a(1, metadata).func_94206_g();
        textureMaxU = block.func_149691_a(1, metadata).func_94212_f();
        textureMaxV = block.func_149691_a(1, metadata).func_94210_h();
        tessellator.func_78374_a(minX, maxY, maxZ, (double)textureMinU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, maxY, minZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(minX, maxY, minZ, (double)textureMinU, (double)textureMinV);
        textureMinU = block.func_149691_a(2, metadata).func_94209_e();
        textureMinV = block.func_149691_a(2, metadata).func_94206_g();
        textureMaxU = block.func_149691_a(2, metadata).func_94212_f();
        textureMaxV = block.func_149691_a(2, metadata).func_94210_h();
        tessellator.func_78374_a(maxX, minY, minZ, (double)textureMinU, (double)textureMaxV);
        tessellator.func_78374_a(minX, minY, minZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(minX, maxY, minZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(maxX, maxY, minZ, (double)textureMinU, (double)textureMinV);
        textureMinU = block.func_149691_a(3, metadata).func_94209_e();
        textureMinV = block.func_149691_a(3, metadata).func_94206_g();
        textureMaxU = block.func_149691_a(3, metadata).func_94212_f();
        textureMaxV = block.func_149691_a(3, metadata).func_94210_h();
        tessellator.func_78374_a(minX, minY, maxZ, (double)textureMinU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, minY, maxZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(minX, maxY, maxZ, (double)textureMinU, (double)textureMinV);
        textureMinU = block.func_149691_a(4, metadata).func_94209_e();
        textureMinV = block.func_149691_a(4, metadata).func_94206_g();
        textureMaxU = block.func_149691_a(4, metadata).func_94212_f();
        textureMaxV = block.func_149691_a(4, metadata).func_94210_h();
        tessellator.func_78374_a(minX, minY, minZ, (double)textureMinU, (double)textureMaxV);
        tessellator.func_78374_a(minX, minY, maxZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(minX, maxY, maxZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(minX, maxY, minZ, (double)textureMinU, (double)textureMinV);
        textureMinU = block.func_149691_a(5, metadata).func_94209_e();
        textureMinV = block.func_149691_a(5, metadata).func_94206_g();
        textureMaxU = block.func_149691_a(5, metadata).func_94212_f();
        textureMaxV = block.func_149691_a(5, metadata).func_94210_h();
        tessellator.func_78374_a(maxX, minY, maxZ, (double)textureMinU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, minY, minZ, (double)textureMaxU, (double)textureMaxV);
        tessellator.func_78374_a(maxX, maxY, minZ, (double)textureMaxU, (double)textureMinV);
        tessellator.func_78374_a(maxX, maxY, maxZ, (double)textureMinU, (double)textureMinV);
        tessellator.func_78381_a();
    }

    public static void setLogToPlank() {
        RandomUtils.getCraftingRecipeForOreDictItem("plankWood", logToPlank);
    }

    public static void getCraftingRecipeForOreDictItem(String ore, HashMap<MapKey, ItemStack> map) {
        ArrayList arrayList = OreDictionary.getOres((String)ore);
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack plank2;
            IRecipe recipe = (IRecipe)o;
            ItemStack output = recipe.func_77571_b();
            if (output == null) continue;
            boolean match = false;
            for (ItemStack plank2 : arrayList) {
                if (!OreDictionary.itemMatches((ItemStack)plank2, (ItemStack)output, (boolean)false)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            ItemStack log = null;
            if (recipe instanceof ShapedRecipes) {
                log = ((ShapedRecipes)recipe).field_77574_d[0];
            } else if (recipe instanceof ShapelessRecipes) {
                log = (ItemStack)((ShapelessRecipes)recipe).field_77579_b.get(0);
            }
            plank2 = output.func_77946_l();
            plank2.field_77994_a = 1;
            if (log == null) continue;
            map.put(new MapKey(log.func_77946_l()), plank2);
        }
    }

    public static NBTTagCompound getModTag(EntityPlayer player, String modName) {
        NBTTagCompound modTag;
        NBTTagCompound persistTag;
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("PlayerPersisted")) {
            persistTag = tag.func_74775_l("PlayerPersisted");
        } else {
            persistTag = new NBTTagCompound();
            tag.func_74782_a("PlayerPersisted", (NBTBase)persistTag);
        }
        if (persistTag.func_74764_b(modName)) {
            modTag = persistTag.func_74775_l(modName);
        } else {
            modTag = new NBTTagCompound();
            persistTag.func_74782_a(modName, (NBTBase)modTag);
        }
        return modTag;
    }

    public static void setOreLumpList() {
        for (String ore : OreDictionary.getOreNames()) {
            if (Strings.isNullOrEmpty((String)ore) || !ore.startsWith("ore")) continue;
            String output = ore.substring(3);
            if (OreDictionary.getOres((String)ore).isEmpty() || OreDictionary.getOres((String)("ingot" + output)).isEmpty()) continue;
            ItemStack stack = new ItemStack(ItemsRegistry.oreLump);
            RandomUtils.checkAndSetCompound(stack);
            stack.field_77990_d.func_74778_a("ore", output);
            oreLumpList.add(stack);
        }
    }

    public static void setTranspositionBlockBlacklist() {
        for (String s : ConfigHandler.transpositionSigilBlacklist) {
            int meta;
            String[] splitSource = s.split(":");
            String modid = splitSource[0];
            String blockName = splitSource[1];
            Block block = GameRegistry.findBlock((String)modid, (String)blockName);
            int n = meta = splitSource[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(splitSource[2]);
            if (block == null) continue;
            transpositionBlockBlacklist.add(new BlockAndMetadata(block, meta));
        }
    }

    public static void setTeleposerBlacklist() {
        for (String s : ConfigHandler.teleposerBlacklist) {
            int meta;
            String[] splitSource = s.split(":");
            String modid = splitSource[0];
            String blockName = splitSource[1];
            Block block = GameRegistry.findBlock((String)modid, (String)blockName);
            int n = meta = splitSource[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(splitSource[2]);
            if (block == null) continue;
            teleposerBlacklist.add(new BlockAndMetadata(block, meta));
        }
    }

    public static ItemStack getOrbForLevel(int orbLevel) {
        switch (orbLevel) {
            default: {
                return new ItemStack(ModItems.weakBloodOrb);
            }
            case 1: {
                return new ItemStack(ModItems.weakBloodOrb);
            }
            case 2: {
                return new ItemStack(ModItems.apprenticeBloodOrb);
            }
            case 3: {
                return new ItemStack(ModItems.magicianBloodOrb);
            }
            case 4: {
                return new ItemStack(ModItems.masterBloodOrb);
            }
            case 5: {
                return new ItemStack(ModItems.archmageBloodOrb);
            }
            case 6: 
        }
        return new ItemStack(ModItems.transcendentBloodOrb);
    }
}

