/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.tile.TileBloodTank;
import tombenpotter.sanguimancy.util.RandomUtils;

public class ItemBloodAmulet
extends Item
implements IFluidContainerItem {
    public int bloodLoss = 1200;

    public ItemBloodAmulet() {
        this.func_77637_a(Sanguimancy.tabSanguimancy);
        this.func_77655_b("Sanguimancy.bloodAmulet");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ri) {
        this.field_77791_bV = ri.func_94245_a("sanguimancy:BloodAmulet");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            float health = livingBase.func_110143_aJ();
            RandomUtils.checkAndSetCompound(stack);
            if (health < 10.0f && stack.func_77942_o() && this.getFluid(stack) != null && this.getFluid(stack).getFluidID() == new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 1).getFluidID() && this.getFluid((ItemStack)stack).amount >= this.bloodLoss) {
                livingBase.func_70691_i(1.0f);
                livingBase.field_70159_w = 0.0;
                livingBase.field_70181_x = 0.0;
                livingBase.field_70179_y = 0.0;
                livingBase.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 1));
                if (this.drain(stack, this.bloodLoss, false) != null) {
                    this.drain(stack, this.bloodLoss, true);
                }
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileBloodTank) {
            TileBloodTank tile = (TileBloodTank)world.func_147438_o(x, y, z);
            if (tile.tank.getFluid() != null && tile.tank.getFluid().getFluidID() == AlchemicalWizardry.lifeEssenceFluid.getID()) {
                tile.drain(ForgeDirection.UNKNOWN, 1000, true);
                this.fill(stack, new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 1000), true);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        if (stack.func_77942_o()) {
            if (!GuiScreen.func_146272_n()) {
                list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shift.info"));
            } else {
                NBTTagCompound tag = stack.field_77990_d.func_74775_l("tank");
                if (stack.func_77942_o() && tag.func_74779_i("FluidName") != "") {
                    list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.fluid") + ": " + RandomUtils.capitalizeFirstLetter(tag.func_74779_i("FluidName")));
                    list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.amount") + ": " + tag.func_74762_e("Amount") + "/" + this.getCapacity(stack) + "mB");
                }
            }
        }
    }

    public FluidStack getFluid(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("tank") && stack.field_77990_d.func_74775_l("tank").func_74779_i("FluidName") != "") {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l("tank");
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return Integer.MAX_VALUE;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (resource == null || stack.field_77994_a != 1) {
            return 0;
        }
        if (resource.getFluidID() != AlchemicalWizardry.lifeEssenceFluid.getID()) {
            return 0;
        }
        int fillAmount = 0;
        int capacity = this.getCapacity(stack);
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            fillAmount = Math.min(capacity, resource.amount);
        }
        if (fluid == null) {
            if (doFill) {
                fluid = resource.copy();
                fluid.amount = 0;
            }
        } else {
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            fillAmount = Math.min(capacity - fluid.amount, resource.amount);
        }
        fillAmount = Math.max(fillAmount, 0);
        if (doFill) {
            if (tag == null) {
                tag = stack.field_77990_d = new NBTTagCompound();
            }
            fluid.amount += fillAmount;
            tag.func_74782_a("tank", (NBTBase)fluid.writeToNBT(fluidTag == null ? new NBTTagCompound() : fluidTag));
        }
        return fillAmount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            if (fluidTag != null) {
                tag.func_82580_o("tank");
            }
            return null;
        }
        int drainAmount = Math.min(maxDrain, fluid.amount);
        if (doDrain) {
            tag.func_82580_o("tank");
            fluid.amount -= drainAmount;
            if (fluid.amount > 0) {
                this.fill(stack, fluid, true);
            }
        }
        fluid.amount = drainAmount;
        return fluid;
    }
}

