/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient boolean useAltHashing;
    final transient int hashSeed = Hashing.randomHashSeed((Object)this);
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private KeySet keySet;
    private Values values;

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = this.newTable(capacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.useAltHashing = VM.isBooted() && capacity >= Holder.ALTERNATIVE_HASHING_THRESHOLD;
    }

    public SoftHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftHashMap() {
        this(16, 0.75f);
    }

    public SoftHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    int hash(Object k) {
        int h;
        if (this.useAltHashing) {
            h = this.hashSeed;
            if (k instanceof String) {
                return Hashing.stringHash32((String)((String)k));
            }
            h ^= k.hashCode();
        } else {
            h = k.hashCode();
        }
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> prev;
                Entry e = (Entry)x;
                int i = SoftHashMap.indexFor(e.hash, this.table.length);
                Entry<K, V> p = prev = this.table[i];
                while (p != null) {
                    Entry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.table[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.value = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object k = SoftHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = SoftHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == h && SoftHashMap.eq(k, e.get())) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = SoftHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = SoftHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (!(e == null || e.hash == h && SoftHashMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(K key, V value) {
        Object k = SoftHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = SoftHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h == e.hash && SoftHashMap.eq(k, e.get())) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        e = tab[i];
        tab[i] = new Entry<K, V>(k, value, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] newTable = this.newTable(newCapacity);
        boolean oldAltHashing = this.useAltHashing;
        this.useAltHashing |= VM.isBooted() && newCapacity >= Holder.ALTERNATIVE_HASHING_THRESHOLD;
        boolean rehash = oldAltHashing ^ this.useAltHashing;
        this.transfer(oldTable, newTable, rehash);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable, false);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest, boolean rehash) {
        for (int j = 0; j < src.length; ++j) {
            Entry<K, V> e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    if (rehash) {
                        e.hash = this.hash(key);
                    }
                    int i = SoftHashMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> prev;
        Object k = SoftHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = SoftHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && SoftHashMap.eq(k, e.get())) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    boolean removeMapping(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = SoftHashMap.maskNull(entry.getKey());
        int h = this.hash(k);
        int i = SoftHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e;
            e = next;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = SoftHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return SoftHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e : this) {
                list.add(new AbstractMap.SimpleEntry(e));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return SoftHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return SoftHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (SoftHashMap.this.containsKey(o)) {
                SoftHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry = null;
        private Entry<K, V> lastReturned = null;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = SoftHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = SoftHashMap.this.isEmpty() ? 0 : SoftHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t = SoftHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (SoftHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SoftHashMap.this.remove(this.currentKey);
            this.expectedModCount = SoftHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry<K, V>
    extends SoftReference<Object>
    implements Map.Entry<K, V> {
        V value;
        int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)SoftHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private static class Holder {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int threshold;
            String altThreshold = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n = threshold = null != altThreshold ? Integer.parseInt(altThreshold) : Integer.MAX_VALUE;
                if (threshold == -1) {
                    threshold = Integer.MAX_VALUE;
                }
                if (threshold < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException failed) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", failed);
            }
            ALTERNATIVE_HASHING_THRESHOLD = threshold;
        }
    }
}

